/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.colortable;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanPrintablePanel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.color.ColorTableBinPanel;
import gov.nasa.giss.ui.color.ColorTablePreviewPanel;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanColorTableFrame
extends PanDisplayFrame
implements DropTargetListener,
Printable,
ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int LABEL_FHGT = 12;
    private static final int LABEL_HGT = 18;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 12);
    private PanPrintablePanel contentPanel_;
    private PanColorTableComboBox clutCombo_;
    private PanButton prefBtn_;
    private ColorTableBinPanel cbPanel_;
    private ColorTablePreviewPanel csPanel_;

    public static PanColorTableFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanColorTableFrame() {
        super("Panoply \u2014 Color Tables");
        if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: " + this.getTitle());
        }
        this.setResizable(false);
        this.setPanMenuBar(new PanMenuBar(this));
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
        this.attachListeners();
    }

    private void createLayout() {
        this.clutCombo_ = PanColorTableComboBox.create(false);
        this.prefBtn_ = PanButton.create(null, "Make Default");
        AbstractColorTable cb = (AbstractColorTable)this.clutCombo_.getSelectedItem();
        Box topBox = Box.createHorizontalBox();
        topBox.add(new JLabel("Show: "));
        topBox.add(this.clutCombo_);
        topBox.add(Box.createHorizontalGlue());
        topBox.add(this.prefBtn_);
        this.csPanel_ = new ColorTablePreviewPanel(cb);
        this.cbPanel_ = new ColorTableBinPanel(cb);
        this.csPanel_.setOutlierShape(ColorTableOutlierShape.TRIANGLE);
        this.contentPanel_ = new PanPrintablePanel();
        this.contentPanel_.setLayout(new BoxLayout(this.contentPanel_, 1));
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.add(topBox);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.csPanel_);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.cbPanel_);
        this.csPanel_.setOpaque(false);
        this.cbPanel_.setOpaque(false);
        this.contentPanel_.setOpaque(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.contentPanel_);
        contentPane.add(this.getStatusBar());
        this.pack();
    }

    private void attachListeners() {
        GuiUtils.makeRecursiveDropTarget(this.csPanel_, this);
        GuiUtils.makeRecursiveDropTarget(this.cbPanel_, this);
        this.clutCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.clutCombo_.isRefreshing()) {
                return;
            }
            Dimension w1 = this.getSize();
            Dimension p1 = this.cbPanel_.getSize();
            AbstractColorTable cb = (AbstractColorTable)this.clutCombo_.getSelectedItem();
            this.csPanel_.setColorTable(cb);
            this.cbPanel_.setColorTable(cb);
            this.pack();
            this.repaint();
            Dimension w2 = this.getSize();
            Dimension p2 = this.cbPanel_.getPreferredSize();
            int dd = p2.height - p1.height - (w2.height - w1.height);
            this.setSize(new Dimension(w2.width, w2.height + dd));
        });
        this.prefBtn_.addActionListener(e -> {
            AbstractColorTable cb = (AbstractColorTable)this.clutCombo_.getSelectedItem();
            if (cb != null) {
                PanPreferences prefs = PanPreferences.getSharedInstance();
                prefs.setString("plot:colorbar.name", cb.toString());
            }
            if (PanPreferencesFrame.instanceExists()) {
                PanPreferencesFrame.getSharedInstance().refresh();
            }
        });
        PanUtils.getColorTableResourceList().addListDataListener(this);
    }

    public void setColorTable(AbstractColorTable clut) {
        this.clutCombo_.setSelectedItem(clut);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiUtils.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!ColorTableFilenameFilter.isColorTableName(f)) continue;
                    addlist.add(f);
                }
                Object[] oo = PanUtils.getColorTableResourceList().addAlphabetic((Component)this, addlist);
                if (oo != null && oo.length > 0) {
                    this.clutCombo_.setSelectedItem(oo[0]);
                }
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiUtils.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        if (jf == this) {
            ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
            AbstractColorTable clut = (AbstractColorTable)reslist.getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.setColorTable(clut));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = new Dimension(Math.max(this.csPanel_.getWidth(), this.cbPanel_.getWidth()), this.csPanel_.getHeight() + this.cbPanel_.getHeight() + 18);
        double scaleX = pf.getImageableWidth() / (double)size.width;
        double scaleY = pf.getImageableHeight() / (double)size.height;
        double scale = Math.min(scaleY, scaleX);
        double tranY = 0.5 * (pf.getImageableHeight() - scale * (double)size.height);
        g2d.translate(pf.getImageableX(), pf.getImageableY() + tranY);
        g2d.scale(scale, scale);
        this.csPanel_.print(g2d);
        g2d.translate(0, this.csPanel_.getHeight());
        this.cbPanel_.print(g2d);
        g2d.translate(0, this.cbPanel_.getHeight() + 18);
        this.drawLabel(g2d, 0);
        return 0;
    }

    private void drawLabel(Graphics2D g2d, int y) {
        g2d.setFont(LABEL_FONT);
        String s = this.clutCombo_.getSelectedItem().toString();
        float x = 0.5f * (float)(this.cbPanel_.getWidth() - (int)GraphicUtils.stringWidth(s, g2d));
        GraphicUtils.drawString(g2d, (Object)s, x, (float)y);
    }

    @Override
    public PanPrintablePanel getPrintable() {
        return this.contentPanel_;
    }

    private static class Singleton {
        private static final PanColorTableFrame INSTANCE = new PanColorTableFrame();

        private Singleton() {
        }
    }
}

