/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.action.task.PanOpenDatasetTask;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCLFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static NcDataset openDataset(Object address) {
        Objects.requireNonNull(address, "Address cannot be null.");
        if (!(address instanceof String || address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address must be String, File, URL or URI.");
        }
        if (address instanceof String) {
            try {
                address = FileUtils.convertStringToAddress((String)address);
            }
            catch (Exception exc) {
                throw new RuntimeException("Address does not look valid.");
            }
        }
        PanOpenDatasetTask task = new PanOpenDatasetTask(address);
        task.openDataset();
        NcDataset ncd = task.getDataset();
        if (ncd == null) {
            String errmsg = task.getErrorMessage();
            LOGGER.debug("Could not create NcDataset from {}: {}", address, (Object)errmsg);
        }
        return ncd;
    }

    private PCLFileUtils() {
    }
}

