/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.authentication;

import gov.nasa.giss.panoply.authentication.PanBasicAuthenticationDialog;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAuthenticationManager
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Hashtable<AuthScope, Credentials> cache_ = new Hashtable(12);
    private static AuthScope lastScope_;

    @Override
    public void clear() {
        cache_.clear();
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope scope) {
        LOGGER.trace("scope {}", (Object)scope);
        Credentials creds = cache_.get(scope);
        if (creds != null) {
            LOGGER.trace("Found cached credentials.");
            return creds;
        }
        LOGGER.trace("Null credentials (so far).");
        if (!EventQueue.isDispatchThread()) {
            LOGGER.trace("Attempted to request credentials on other than event thread.");
            throw new RuntimeException("Cannot authorize. Attempt to request credentials must be made on event thread.");
        }
        PanFrame aframe = PanFrame.getActiveFrame();
        PanBasicAuthenticationDialog dlog = new PanBasicAuthenticationDialog(aframe, scope);
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            return null;
        }
        try {
            creds = new UsernamePasswordCredentials(dlog.getUserid(), dlog.getPassword());
        }
        catch (Exception exc) {
            LOGGER.trace("Exception building UsernamePasswordCredentials");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw exc;
        }
        this.setCredentials(scope, creds);
        lastScope_ = scope;
        return creds;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        LOGGER.trace("");
        cache_.put(authscope, credentials);
    }

    public static void setLastCredentialsRejected() {
        LOGGER.trace("lastScope {}", (Object)lastScope_);
        if (lastScope_ != null) {
            cache_.remove(lastScope_);
        }
    }
}

