/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.task;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.panoply.authentication.PanAuthenticationManager;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenDatasetTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Object address_;
    private String errMsg_;
    private boolean tryAgainOnEDT_;
    private NcDataset dataset_;

    public PanOpenDatasetTask(Object address) {
        Objects.requireNonNull(address, "Address cannot be null.");
        if (!(address instanceof File || address instanceof URL || address instanceof URI)) {
            throw new IllegalArgumentException("Address object must be File, URI, URL.");
        }
        this.address_ = address;
    }

    @Override
    protected Object beginTask() {
        this.openDataset();
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.dataset_ == null && this.tryAgainOnEDT_) {
            this.openDataset();
        }
        if (this.dataset_ == null || this.errMsg_ != null) {
            GuiUtils.showSlowMessage(null, "File Error", "There was an error opening the dataset:\n" + this.errMsg_);
            return;
        }
        try {
            PanSourcesFrame.getSharedInstance().addDataset(this.dataset_);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not add dataset to Sources window: {}", (Object)exc.toString());
        }
        PanSourcesFrame.getSharedInstance().reveal();
    }

    public void openDataset() {
        block42: {
            try {
                URL url = null;
                if (this.address_ instanceof File) {
                    url = ((File)this.address_).toURI().toURL();
                } else if (this.address_ instanceof URL) {
                    url = (URL)this.address_;
                } else if (this.address_ instanceof URI) {
                    url = ((URI)this.address_).toURL();
                }
                this.dataset_ = new NcDataset(url);
            }
            catch (HeadlessException hexc) {
                if (!PlatformUtils.isHeadless()) {
                    LOGGER.warn("HeadlessException opening dataset. Will try again on EDT.");
                    this.tryAgainOnEDT_ = true;
                    this.errMsg_ = null;
                }
            }
            catch (ConnectException exc) {
                LOGGER.warn("ConnectException opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
            }
            catch (NcException exc) {
                LOGGER.warn("NcException opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
            }
            catch (MalformedURLException exc) {
                LOGGER.warn("MalformedURLException opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = exc.toString();
            }
            catch (FileNotFoundException exc) {
                LOGGER.warn("FileNotFoundException opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = "No file found at that address.";
            }
            catch (IOException exc) {
                LOGGER.warn("IOException opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
                String lc = this.errMsg_.toLowerCase();
                if (lc.contains("authoriz")) {
                    if (!EventQueue.isDispatchThread()) {
                        LOGGER.warn("Will try again on EDT");
                        this.tryAgainOnEDT_ = true;
                        this.errMsg_ = null;
                    } else {
                        LOGGER.warn("On EDT... authorization failed.");
                        PanAuthenticationManager.setLastCredentialsRejected();
                        this.errMsg_ = "Authorization required to access dataset.";
                    }
                } else if (this.errMsg_.contains("not a valid CDM file")) {
                    this.errMsg_ = "The file does not seem to be valid CDM.";
                } else if (lc.matches(".*could not find a table for grib file.*")) {
                    this.errMsg_ = this.errMsg_ + "\nYou must first either open an appropriate local GRIB table or else turn off GRIB-1 \"strict mode\" in Preferences before opening this dataset.";
                } else if (lc.matches(".*status.*403.*")) {
                    this.errMsg_ = "Access is forbidden.";
                } else if (lc.matches(".*status.*404.*")) {
                    this.errMsg_ = "No resource was found at that address.";
                } else if (lc.matches(".*status.*408.*")) {
                    this.errMsg_ = "Request timed out.";
                } else if (lc.matches(".*status.*414.*") || this.errMsg_.contains("414 Request")) {
                    this.errMsg_ = "Server denied response; request URI is much too long.";
                } else if (lc.matches(".*response.*503.*")) {
                    this.errMsg_ = "Service is unavailable; please try again later.";
                } else if (lc.matches(".*clientprotocol.*")) {
                    this.errMsg_ = "A protocol exception occurred.";
                } else if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Exception opening dataset: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.errMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
                String lc = this.errMsg_.toLowerCase();
                this.errMsg_ = lc.contains("connection refused") ? "Connection was refused." : (lc.contains("parseexception") || this.errMsg_.contains("parser") ? "Unable to parse dataset info." : (lc.contains("filenotfound") ? "Dataset was not found." : exc.toString().replaceFirst(".*HTTP", "HTTP")));
                if (!LOGGER.isTraceEnabled()) break block42;
                exc.printStackTrace();
            }
        }
        if (this.dataset_ == null && this.errMsg_ == null && !this.tryAgainOnEDT_) {
            this.errMsg_ = "Uncaught/unknown exception.";
        }
    }

    public NcDataset getDataset() {
        return this.dataset_;
    }

    public String getErrorMessage() {
        return this.errMsg_;
    }
}

