/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.task;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDump;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCdlTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;
    private final NcDataNode node_;
    private final File file_;
    private String errMsg_;

    public PanExportCdlTask(PanSourcesFrame parent, NcDataNode node, File file) {
        super("Writing CDL text file");
        Objects.requireNonNull(node, "Cannot export a null node.");
        if (!(node instanceof NcDataset) && !(node instanceof NcVariable)) {
            throw new IllegalArgumentException("Node must be dataset or variable.");
        }
        this.parent_ = parent;
        this.node_ = node;
        this.file_ = file;
    }

    @Override
    protected Object beginTask() {
        try {
            if (this.node_ instanceof NcDataset) {
                NcDump.exportCdl(this.file_, (NcDataset)this.node_);
            } else if (this.node_ instanceof NcVariable) {
                NcDump.exportCdl(this.file_, (NcVariable)this.node_);
            }
        }
        catch (Exception exc) {
            LOGGER.error("Could not write data to a CDL text file.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString();
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ != null) {
            GuiUtils.showSlowMessage((Component)this.parent_, "Output Error", new StringBuilder("There was an error preparing the data: ").append(this.errMsg_));
        }
    }
}

