/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.task;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotSizeFactor;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.task.Task;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCreatePlotTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final NcVariable ncvar_;
    private final Hashtable<PanCreatePlotOption, Object> options_;
    private String errMsg_;
    private PanPlotMeta pmeta_;

    public PanCreatePlotTask(NcVariable ncvar, Hashtable<PanCreatePlotOption, Object> options) {
        super("Creating plot");
        this.ncvar_ = ncvar;
        this.options_ = options;
    }

    @Override
    protected Object beginTask() {
        PanData data;
        PanPlotSizeFactor psize = (PanPlotSizeFactor)this.options_.get((Object)PanCreatePlotOption.SIZE_FACTOR);
        PanPlotType ptype = (PanPlotType)this.options_.get((Object)PanCreatePlotOption.PLOT_TYPE);
        int sizeFactor = psize == null ? PREFS.getInt("plot:size.factor") : psize.getSizeFactor();
        try {
            this.pmeta_ = new PanPlotMeta(ptype, sizeFactor);
        }
        catch (Exception exc) {
            LOGGER.error("Exception creating PanPlotMeta object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "Failed creating the plot manager: " + this.errMsg_;
            return null;
        }
        if (this.pmeta_ == null) {
            LOGGER.error("PanPlotMeta object is null despite lack of reported error.");
            this.errMsg_ = "The plot manager is null despite lack of reported error.";
            return null;
        }
        try {
            Object d1 = this.options_.containsKey((Object)PanCreatePlotOption.AXIS_INFO_1) ? this.options_.get((Object)PanCreatePlotOption.AXIS_INFO_1) : null;
            Object d2 = this.options_.containsKey((Object)PanCreatePlotOption.AXIS_INFO_2) ? this.options_.get((Object)PanCreatePlotOption.AXIS_INFO_2) : null;
            data = this.pmeta_.createData(this.ncvar_, d1, d2);
        }
        catch (Exception exc) {
            LOGGER.error("Exception creating PanPlotData object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "Failed creating the data handler: " + this.errMsg_;
            LOGGER.error("{}", (Object)this.errMsg_);
            return null;
        }
        if (data == null) {
            LOGGER.error("PanData object is null despite lack of reported error.");
            this.errMsg_ = "Data handler is null despite lack of reported error.";
            return null;
        }
        try {
            data.getMinValue();
        }
        catch (Exception exc) {
            LOGGER.error("Exception scanning data for min/max values: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an error scanning the data for min/max values.";
            return null;
        }
        try {
            LOGGER.trace("Create plot");
            this.pmeta_.createPlot();
            LOGGER.trace("Created {}", (Object)(this.pmeta_.getPlot() != null ? 1 : 0));
        }
        catch (Exception exc) {
            LOGGER.error("Exception creating PanPlot object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "Failed creating the plot object: " + this.errMsg_;
            return null;
        }
        try {
            if (data instanceof PanData1D) {
                ((PanData1D)data).valueAt(0, 0);
            } else if (data instanceof PanData2D) {
                ((PanData2D)data).valueAt(0, 0);
            }
        }
        catch (Exception exc) {
            LOGGER.error("There was an error performing initial data gridding:");
            LOGGER.error("{}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "Initial data gridding failed: " + this.errMsg_;
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ != null) {
            if (!this.errMsg_.endsWith(".")) {
                this.errMsg_ = this.errMsg_ + ".";
            }
            LOGGER.error("Displaying error message: {}", (Object)this.errMsg_);
            GuiUtils.showSlowMessage(null, "Plot Error", new StringBuilder("There was an error preparing the data: ").append(this.errMsg_));
            return;
        }
        try {
            new PanPlotFrame(this.pmeta_).reveal();
        }
        catch (Exception exc) {
            Object excStr;
            int colon;
            LOGGER.error("There was an error constructing the plot window:");
            LOGGER.error("{}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((colon = ((String)(excStr = exc.toString())).indexOf(58)) >= 0) {
                String first = ((String)excStr).substring(0, colon).replaceFirst(".*\\.", "");
                String second = ((String)excStr).substring(colon);
                excStr = first + second;
            }
            GuiUtils.showSlowMessage(null, "Plot Error", "There was an error creating the plot window. " + (String)excStr);
        }
    }
}

