/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanToggleToolbarLabelsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("toggle-toolbar-labels");
    private long last_;

    public static synchronized PanToggleToolbarLabelsAction getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanToggleToolbarLabelsAction() {
        super(ACTION_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long now = System.currentTimeMillis();
        if (now - this.last_ >= 200L) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            boolean newVal = !prefs.getBoolean("sources:toolbar.labels");
            prefs.setBoolean("sources:toolbar.labels", newVal);
            PanSourcesFrame.getSharedInstance().refresh();
        }
        GuiUtils.refreshFrontFrameMenuBar();
        this.last_ = now;
    }

    private static class Singleton {
        private static final PanToggleToolbarLabelsAction INSTANCE = new PanToggleToolbarLabelsAction();

        private Singleton() {
        }
    }
}

