/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

public final class MathUtils {
    public static boolean dequals(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public static final double sq(double val) {
        if (Double.isNaN(val)) {
            return Double.NaN;
        }
        return val * val;
    }

    public static int max(int ... intvals) {
        int max = Integer.MIN_VALUE;
        for (int ival : intvals) {
            max = Math.max(max, ival);
        }
        return max;
    }

    public static double max(double ... dvals) {
        double max = -1.7976931348623157E308;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            if (!(dval > max)) continue;
            max = dval;
        }
        return max;
    }

    public static int min(int ... intvals) {
        int min = Integer.MAX_VALUE;
        for (int ival : intvals) {
            min = Math.min(min, ival);
        }
        return min;
    }

    public static float min(float ... fvals) {
        float min = Float.MAX_VALUE;
        for (float fval : fvals) {
            if (Float.isNaN(fval)) {
                return Float.NaN;
            }
            min = Math.min(min, fval);
        }
        return min;
    }

    public static double min(double ... dvals) {
        double min = Double.MAX_VALUE;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            min = Math.min(min, dval);
        }
        return min;
    }

    public static int constrain(int min, int max, int value) {
        int result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static int constrain0(int max, int value) {
        return MathUtils.constrain(0, max, value);
    }

    public static float constrain(float min, float max, float value) {
        if (Float.isNaN(value) || Float.isNaN(min) || Float.isNaN(max)) {
            return value;
        }
        float result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static double constrain(double min, double max, double value) {
        if (Double.isNaN(value) || Double.isNaN(min) || Double.isNaN(max)) {
            return value;
        }
        double result = Math.min(value, max);
        result = Math.max(result, min);
        return result;
    }

    public static int sum(int ... intvals) {
        int sum = 0;
        for (int ival : intvals) {
            sum += ival;
        }
        return sum;
    }

    public static float sum(float ... fvals) {
        float sum = 0.0f;
        for (float fval : fvals) {
            if (Float.isNaN(fval)) {
                return Float.NaN;
            }
            sum += fval;
        }
        return sum;
    }

    public static double sum(double ... dvals) {
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            sum += dval;
        }
        return sum;
    }

    public static double average(double ... dvals) {
        if (dvals.length == 0) {
            throw new IllegalArgumentException("No values to average.");
        }
        int icount = 0;
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) {
                return Double.NaN;
            }
            sum += dval;
            ++icount;
        }
        if (icount == 0) {
            return Double.NaN;
        }
        return sum / (double)icount;
    }

    public static double average2(double ... dvals) {
        if (dvals.length == 0) {
            throw new IllegalArgumentException("No values to average.");
        }
        int icount = 0;
        double sum = 0.0;
        for (double dval : dvals) {
            if (Double.isNaN(dval)) continue;
            sum += dval;
            ++icount;
        }
        if (icount == 0) {
            return Double.NaN;
        }
        return sum / (double)icount;
    }

    public static final double arcosh(double val) {
        return Math.log(val + Math.sqrt(val * val - 1.0));
    }

    public static final double artanh(double val) {
        return 0.5 * Math.log((1.0 + val) / (1.0 - val));
    }

    private MathUtils() {
    }
}

