/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ProjListComponent
extends ProjParamComponent {
    private static final long serialVersionUID = 181L;
    private ProjListParameter parameter_;
    private JComboBox<Object> cbox_;

    public ProjListComponent(ProjListParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjListComponent(ProjListParameter parameter, Object value) {
        this(parameter, value, false);
    }

    public ProjListComponent(ProjListParameter parameter, Object value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.createLayout(value, padded);
        this.attachListeners();
    }

    private void createLayout(Object value, boolean padded) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ":\u2009");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.cbox_ = new JComboBox<Object>(this.parameter_.getChoices());
        this.cbox_.setOpaque(false);
        this.cbox_.setSelectedItem(value);
        this.cbox_.setMaximumRowCount(32);
        this.add(this.cbox_);
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void attachListeners() {
        this.cbox_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.handleParam();
        });
    }

    public JComboBox<Object> getComboBox() {
        return this.cbox_;
    }

    @Override
    public void reset() {
        this.cbox_.setSelectedItem(this.parameter_.getDefault());
        this.handleParam();
    }

    @Override
    public String getStringValue() {
        return this.getValue().toString();
    }

    @Override
    public Object getValue() {
        return this.cbox_.getSelectedItem();
    }

    public void setValue(Object value) {
        this.cbox_.setSelectedItem(value);
        this.parameter_.setValue(value);
        super.fireValueChanged();
    }

    @Override
    public void setValue(String value) {
        int isize = this.cbox_.getItemCount();
        for (int i = 0; i < isize; ++i) {
            Object o = this.cbox_.getItemAt(i);
            if (!value.equals(o.toString())) continue;
            this.cbox_.setSelectedIndex(i);
            this.parameter_.setIndex(i);
            break;
        }
        super.fireValueChanged();
    }

    public void setValue(int index) {
        this.cbox_.setSelectedIndex(index);
        this.parameter_.setIndex(index);
        super.fireValueChanged();
    }

    @Override
    protected void handleParam() {
        this.parameter_.setValue(this.cbox_.getSelectedItem());
        super.fireValueChanged();
    }
}

