/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public class ProjBooleanComponent
extends ProjParamComponent {
    private static final long serialVersionUID = 181L;
    private final ProjBooleanParameter parameter_;
    private JCheckBox cbox_;

    public ProjBooleanComponent(ProjBooleanParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjBooleanComponent(ProjBooleanParameter parameter, boolean value) {
        this(parameter, value, false);
    }

    public ProjBooleanComponent(ProjBooleanParameter parameter, boolean value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.createLayout(value, padded);
        this.attachListeners();
    }

    private void createLayout(boolean value, boolean padded) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.cbox_ = new JCheckBox(this.parameter_.getLabel(), value);
        this.cbox_.setOpaque(false);
        this.add(this.cbox_);
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void attachListeners() {
        this.cbox_.addItemListener(e -> this.handleParam());
    }

    @Override
    public void reset() {
        this.setSelected(this.parameter_.getDefault());
        this.handleParam();
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this.isSelected());
    }

    @Override
    public Object getValue() {
        return this.isSelected();
    }

    public boolean isEnabled(boolean bb) {
        return this.cbox_.isEnabled();
    }

    @Override
    public void setEnabled(boolean bb) {
        this.cbox_.setEnabled(bb);
    }

    public boolean isSelected() {
        return this.cbox_.isSelected();
    }

    public void setSelected(boolean bb) {
        this.cbox_.setSelected(bb);
        this.parameter_.setSelected(bb);
        super.fireValueChanged();
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        try {
            this.setSelected(Boolean.valueOf(sval));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a Boolean: " + sval);
        }
    }

    @Override
    protected void handleParam() {
        this.parameter_.setSelected(this.cbox_.isSelected());
        super.fireValueChanged();
    }
}

