/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Wagner4
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner IV";
    private static final double CONST_P = 1.0471975511965976;
    private static final double SIN_P = Math.sin(1.0471975511965976);
    private static final double TWO_P = 2.0943951023931953;
    private static final double CSUBP = 2.0943951023931953 + Math.sin(2.0943951023931953);
    private static final double INV_CSUBP = 1.0 / CSUBP;
    private static final double CONST_R = Math.sqrt(Math.PI * 2 * SIN_P * INV_CSUBP);
    private static final double CSUBX = CONST_R * 0.6366197723675814;
    private static final double CSUBY = CONST_R / SIN_P;
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double MAX_X_OVER_RS = CSUBX * Math.PI;
    private static final double MAX_Y_OVER_RS = CSUBY * SIN_P;

    public Wagner4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiFactor = CSUBP * Math.sin(phiRad);
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - phiFactor;
            double dfunc = 2.0 * (1.0 + Math.cos(twoThetaRad));
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = CSUBX * this.lonToLambdaRad(lon) * Math.cos(thetaRad);
        double y = CSUBY * Math.sin(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.invRS_ * INV_CSUBY);
        double twoThetaRad = 2.0 * thetaRad;
        double phiRad = Math.asin((twoThetaRad + Math.sin(twoThetaRad)) * INV_CSUBP);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ * INV_CSUBX / Math.cos(thetaRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner4 wagner4 = this;
        synchronized (wagner4) {
            double y;
            double thetaRad;
            double twoThetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(((twoThetaRad = 2.0 * (thetaRad = Math.asin((y = (double)iy + 0.5) * this.invRS_ * INV_CSUBY))) + Math.sin(twoThetaRad)) * INV_CSUBP)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * INV_CSUBX / Math.cos(thetaRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

