/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanDerGrinten4
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Van der Grinten IV";
    public static final int PROPERTIES = 32;
    private static final double PI_OVER_8 = 0.39269908169872414;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.9634954084936207;

    public VanDerGrinten4(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, 1.9634954084936207);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5) {
            x = 0.0;
            y = absPhiRad;
        } else if (absPhiRad < 1.0E-5) {
            x = absLambdaRad;
            y = 0.0;
        } else if (absPhiRad > 1.5707963266948965) {
            x = 0.0;
            y = 1.5707963267948966;
        } else {
            double dz = 0.6366197723675814 * absLambdaRad + 1.5707963267948966 / absLambdaRad;
            double d2 = dz * dz - 4.0;
            double d = Math.sqrt(d2);
            if (absLambdaRad - 1.5707963267948966 < 0.0) {
                d = -d;
            }
            double b = absPhiRad * 0.6366197723675814;
            double b2 = b * b;
            double b3 = b2 * b;
            double cnumer = 8.0 * b - b2 * b2 - 2.0 * b2 - 5.0;
            double cdenom = 2.0 * (b3 - b2);
            double c = cnumer / cdenom;
            double c2 = c * c;
            double fourC2 = 4.0 * c2;
            double bpc = b + c;
            double bpc2 = bpc * bpc;
            double bp3c = b + 3.0 * c;
            double ffz = b2 * (bp3c * bp3c + fourC2) + c2 * (12.0 * b * c + fourC2);
            double ff = bpc2 * (b2 + c2 * d2 - 1.0) + (1.0 - b2) * ffz;
            double sqrtff = Math.sqrt(ff);
            double x1numer = d * (bpc2 + c2 - 1.0) + 2.0 * sqrtff;
            double x1denom = 4.0 * bpc2 + d2;
            double x1 = x1numer / x1denom;
            x = 1.5707963267948966 * x1;
            y = 1.5707963267948966 * Math.sqrt(1.0 + d * Math.abs(x1) - x1 * x1);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = Math.abs(x * this.invRS_);
        double yOverRS = Math.abs(y * this.invRS_);
        if (y == 0.0) {
            if (xOverRS > Math.PI) {
                return null;
            }
            lambdaRad = xOverRS;
            phiRad = 0.0;
        } else if (xOverRS < 1.0E-10) {
            if (yOverRS > 1.5707963267948966) {
                return null;
            }
            lambdaRad = 0.0;
            phiRad = yOverRS;
        } else {
            double x2 = xOverRS * xOverRS;
            double y2 = yOverRS * yOverRS;
            double xc = (x2 + y2 - 2.4674011002723395) / (2.0 * xOverRS);
            double radius = Math.sqrt(xc * xc + 2.4674011002723395);
            lambdaRad = xc + radius;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
            phiRad = this.iteratePhiRad(xOverRS, yOverRS, lambdaRad);
            if (Double.isNaN(phiRad)) {
                return null;
            }
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten4 vanDerGrinten4 = this;
        synchronized (vanDerGrinten4) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y * this.invRS_);
                double y2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double radius;
                    double x = (double)ix + 0.5;
                    double xOverRS = Math.abs(x * this.invRS_);
                    double x2 = xOverRS * xOverRS;
                    double xc = (x2 + y2 - 2.4674011002723395) / (2.0 * xOverRS);
                    double lambdaRad = xc + (radius = Math.sqrt(xc * xc + 2.4674011002723395));
                    if (Math.abs(lambdaRad) > Math.PI) continue;
                    double phiRad = this.iteratePhiRad(xOverRS, yOverRS, lambdaRad);
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double iteratePhiRad(double xOverRS, double yOverRS, double lambdaRad) {
        double dz = 0.6366197723675814 * lambdaRad + 1.5707963267948966 / lambdaRad;
        double d2 = dz * dz - 4.0;
        double d = Math.sqrt(d2);
        if (lambdaRad - 1.5707963267948966 < 0.0) {
            d = -d;
        }
        double x1 = xOverRS * 0.6366197723675814;
        double b = yOverRS * 0.6366197723675814;
        if (lambdaRad > 1.5707963267948966) {
            b = xOverRS < 0.39269908169872414 ? 0.95 : b * 0.8;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double twoB = 2.0 * b;
            double b2 = b * b;
            double b3 = b2 * b;
            double cnumer = 8.0 * b - b2 * b2 - 2.0 * b2 - 5.0;
            double cdenom = 2.0 * (b3 - b2);
            double c = cnumer / cdenom;
            double c2 = c * c;
            double fourC2 = 4.0 * c2;
            double bpc = b + c;
            double bpc2 = (b + c) * (b + c);
            double bp3c = b + 3.0 * c;
            double ffz = b2 * (bp3c * bp3c + fourC2) + c2 * (12.0 * b * c + fourC2);
            double ff = bpc2 * (b2 + c2 * d2 - 1.0) + (1.0 - b2) * ffz;
            double sqrtff = Math.sqrt(ff);
            double x1numer = d * (bpc2 + c2 - 1.0) + 2.0 * sqrtff;
            double x1denom = 4.0 * bpc2 + d2;
            double dcnumerDb = 8.0 - 4.0 * b3 - 4.0 * b;
            double dcdenomDb = 6.0 * b2 - 4.0 * b;
            double dcDb = dcnumerDb / cdenom - cnumer * dcdenomDb / (cdenom * cdenom);
            double dc2Db = 2.0 * c * dcDb;
            double dbpc2Db = 2.0 * bpc * (1.0 + dcDb);
            double dbp3cDb = 1.0 + 3.0 * dcDb;
            double dffzDb = twoB * (bp3c * bp3c + fourC2) + b2 * (2.0 * bp3c * dbp3cDb + 4.0 * dc2Db) + dc2Db * (12.0 * b * c + fourC2) + c2 * (12.0 * c + 12.0 * b * dcDb + 4.0 * dc2Db);
            double dffDb = dbpc2Db * (b2 + c2 * d2 - 1.0) + bpc2 * (twoB + dc2Db * d2) - twoB * ffz + (1.0 - b2) * dffzDb;
            double dx1numerDb = d * (dbpc2Db + dc2Db) + dffDb / sqrtff;
            double dx1denomDb = 4.0 * dbpc2Db;
            double func = x1numer / x1denom - x1;
            double dfunc = dx1numerDb / x1denom - x1numer * dx1denomDb / (x1denom * x1denom);
            double db = -func / dfunc;
            b += db;
            if (Math.abs(db) < 1.0E-5) break;
        }
        double phiRad = b * 1.5707963267948966;
        return phiRad;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double lona = this.lambdaC_ + 179.99999;
        double lonb = this.lambdaC_ - 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lona, 90.0);
        Point2D.Double dot2e = this.transformLL2XY(lona, 0.0);
        Point2D.Double dot2w = this.transformLL2XY(lonb, 0.0);
        Point2D.Double dot3 = this.transformLL2XY(lona, -90.0);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2e, dot3);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2w, dot3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ - 179.99998;
        double lon3 = this.lambdaC_ + 179.99998;
        Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dot1, dot3);
        } else {
            double lon2 = this.lambdaC_;
            Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
            if (dot1 == null || dot3 == null) {
                LOGGER.trace("Bad dot for lat {} -- {}, {}", lat, dot1, dot3);
                return;
            }
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            GraphicUtils.drawCircularArc(g2d, dotN, dotEq, dotS);
        }
    }
}

