/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.EllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class VanDerGrinten3
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Van der Grinten III";
    public static final int PROPERTIES = 8;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double rhoBorder_;
    private double rhoBorder2_;

    public VanDerGrinten3(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-5) {
            double x2 = lambdaRad;
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        if (absLat > 89.99999) {
            double x3 = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            x3 = (double)this.outCenterX_ + x3 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x3, y);
        }
        double absPhiRad = Math.toRadians(absLat);
        double sinTheta = absPhiRad * 0.6366197723675814;
        double cosTheta = Math.sqrt(1.0 - sinTheta * sinTheta);
        double tanHalfTheta = sinTheta / (1.0 + cosTheta);
        double y = Math.PI * tanHalfTheta;
        if (lambdaRad == 0.0) {
            x = 0.0;
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
        } else {
            double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
            x = Math.PI * (Math.sqrt(a * a + 1.0 - tanHalfTheta * tanHalfTheta) - a);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double absY = Math.abs(y);
        double tanHalfTheta = absY * this.invRS_ * 0.3183098861837907;
        double thetaRad = 2.0 * Math.atan(tanHalfTheta);
        double phiRad = Math.sin(thetaRad) * 1.5707963267948966;
        if (Double.isNaN(phiRad) || phiRad > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double absX = Math.abs(x);
        double lambdaRad = absX > 1.0E-5 && phi < 89.99999 ? this.iterateLambdaRad(absX, phiRad, tanHalfTheta) : this.lambdaCRad_;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten3 vanDerGrinten3 = this;
        synchronized (vanDerGrinten3) {
            double y;
            double tanHalfTheta;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.sin(thetaRad = 2.0 * Math.atan(tanHalfTheta = (y = (double)iy + 0.5) * this.invRS_ * 0.3183098861837907)) * 1.5707963267948966) > 1.5707963267948966); ++iy) {
                double lambdaRad;
                double x;
                double rho2;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; !(ix >= this.dxMax_ || (rho2 = (x = (double)ix + 0.5) * x + y * y) > this.rhoBorder2_ || (lambdaRad = phi < 89.995 ? this.iterateLambdaRad(x, phiRad, tanHalfTheta) : this.lambdaCRad_) > Math.PI || Double.isNaN(lambdaRad)); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateLambdaRad(double absX, double phiRad, double tanHalfTheta) {
        double xOverRS = absX * this.invRS_;
        double tanSqHalfTheta = tanHalfTheta * tanHalfTheta;
        double lambdaRad = xOverRS * Math.cos(phiRad);
        for (int iter = 0; iter < 33; ++iter) {
            double a = 0.5 * (Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
            double daDlambda = 0.5 * (-Math.PI / (lambdaRad * lambdaRad) - 0.3183098861837907);
            double sqrtTerm = Math.sqrt(a * a + 1.0 - tanSqHalfTheta);
            double func = Math.PI * (sqrtTerm - a) - xOverRS;
            double dfunc = Math.PI * (0.5 / sqrtTerm * 2.0 * a - 1.0) * daDlambda;
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 179.99999;
        double rlon = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot2.x - (double)fh2 - (double)w);
            g2d.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(des / 2)));
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot1, dot2);
        g2d.setClip(oldclip);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambda = Math.abs(lambdaRad);
        if (absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, this.outCenterX_, (double)this.outCenterY_ - this.rhoBorder_, this.outCenterX_, (double)this.outCenterY_ + this.rhoBorder_);
        } else {
            double dxEq = this.rhoBorder_ * lambdaRad * 0.3183098861837907;
            GraphicUtils.drawCircularArc(g2d, this.outCenterX_, (double)this.outCenterY_ - this.rhoBorder_, (double)this.outCenterX_ + dxEq, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ + this.rhoBorder_);
        }
    }
}

