/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import java.awt.Graphics2D;
import java.awt.Insets;

public abstract class TwoHemisphereGlobularProjection
extends AbstractProjection {
    protected double rhoBorder_;
    protected double rhoBorder2_;
    protected int leftCenterX_;
    protected int rightCenterX_;

    public TwoHemisphereGlobularProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double rMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, 2.04 * rMaxOverR, rMaxOverR);
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_ * 1.5707963267948966;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.getWidth() - ins.right));
    }

    protected void setInvPoints(int ix, int iy, double lambdaP, double phiP) {
        this.setInvPoint(true, ix, iy, this.lambdaC_ + lambdaP, phiP);
        this.setInvPoint(true, ix, -iy - 1, this.lambdaC_ + lambdaP, -phiP);
        this.setInvPoint(true, -ix - 1, -iy - 1, this.lambdaC_ - lambdaP, -phiP);
        this.setInvPoint(true, -ix - 1, iy, this.lambdaC_ - lambdaP, phiP);
        this.setInvPoint(false, ix, iy, this.lambdaC_ + lambdaP + 180.0, phiP);
        this.setInvPoint(false, ix, -iy - 1, this.lambdaC_ + lambdaP + 180.0, -phiP);
        this.setInvPoint(false, -ix - 1, -iy - 1, this.lambdaC_ - lambdaP + 180.0, -phiP);
        this.setInvPoint(false, -ix - 1, iy, this.lambdaC_ - lambdaP + 180.0, phiP);
    }

    private void setInvPoint(boolean leftside, int ix, int iy, double lon, double lat) {
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
        ProjectionUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
    }
}

