/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class Stereographic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Stereographic";
    public static final int PROPERTIES = 2101312;
    private static final double MAX_CLIP_ANGLE = 150.0;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;

    public Stereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Stereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2101312, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 150.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = 2.0 * Math.tan(0.5 * this.edgeAngleRad_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.fillCorners_ ? this.rS_ * 2.0 * Math.tan(0.5 * Math.toRadians(150.0)) : this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == -1.0) {
            return -1.0;
        }
        return 2.0 / (1.0 + cosZ);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return 2.0 * Math.atan(0.5 * rho * this.invRS_);
    }
}

