/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Siemon4
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Siemon IV";
    private static final double CONST_C = 1.772453850905516 / Math.sqrt(2.8284271247461903);
    private static final double TWO_C = 2.0 * CONST_C;
    private static final double INV_C = 1.0 / CONST_C;
    private static final double INV_2C = 0.5 * INV_C;
    private static final double MAX_X_OVER_RS = Math.PI * INV_C;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951 * CONST_C;
    private double cOverRS_;

    public Siemon4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Siemon4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.cOverRS_ = CONST_C * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (lat == 0.0 && !this.isShowingInterrupted()) {
            double x2 = lambdaRad * INV_C;
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        double phiRad = Math.toRadians(lat);
        double halfPhiRad = 0.5 * phiRad;
        double phiFactor = INV_C * Math.cos(phiRad) / Math.cos(halfPhiRad);
        double y = TWO_C * Math.sin(halfPhiRad);
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon) * phiFactor;
            double cx = this.lonToLambdaRad(clon) * INV_C;
            x = cx + dx;
        } else {
            x = lambdaRad * phiFactor;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (y == 0.0) {
            phiRad = 0.0;
            xFactor = this.cOverRS_;
        } else {
            double yOverRS = y * this.invRS_;
            double sinHalfPhi = yOverRS * INV_2C;
            double halfPhiRad = Math.asin(sinHalfPhi);
            phiRad = 2.0 * halfPhiRad;
            xFactor = this.cOverRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.cOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Siemon4 siemon4 = this;
        synchronized (siemon4) {
            double y;
            double yOverRS;
            double sinHalfPhi;
            double halfPhiRad;
            double phiRad = 0.0;
            for (int iy = -this.dyMax_; iy < this.dyMax_ && !((phiRad = 2.0 * (halfPhiRad = Math.asin(sinHalfPhi = (yOverRS = (y = (double)iy + 0.5) * this.invRS_) * INV_2C))) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.cOverRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.cOverRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

