/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class PutninsP5p
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P5'";
    private static final double CONST_A = 1.013456;
    private static final double CONST_B = 1.2158542037080533;
    private static final double MAX_X_OVER_RS = 3.183865924336497;
    private static final double MAX_Y_OVER_RS = 1.5919329621682485;
    private double invRSA_;

    public PutninsP5p(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP5p(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 3.183865924336497, 1.5919329621682485);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invRSA_ = this.invRS_ / 1.013456;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double x = 0.506728 * this.lonToLambdaRad(lon) * (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        double y = 1.013456 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRSA_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRSA_ * 2.0 / (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PutninsP5p putninsP5p = this;
        synchronized (putninsP5p) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRSA_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRSA_ * 2.0 / (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

