/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

final class ProjectionUtils {
    private ProjectionUtils() {
    }

    static void drawRect(Graphics2D g2d, double x, double y, double w, double h) {
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        g2d.draw(r);
    }

    static void drawEllipse(Graphics2D g2d, double centerX, double centerY, double wRadius, double hRadius) {
        g2d.translate(centerX, centerY);
        g2d.draw(new Ellipse2D.Double(-wRadius, -hRadius, 2.0 * wRadius, 2.0 * hRadius));
        g2d.translate(-centerX, -centerY);
    }

    static void drawRectBorder(Graphics2D g2d, double left, double top, double width, double height) {
        BasicStroke bstroke;
        Stroke oldstroke = g2d.getStroke();
        if (oldstroke instanceof BasicStroke && ((bstroke = (BasicStroke)oldstroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(ProjectionUtils.getSquareMiterStroke(bstroke.getLineWidth()));
        }
        ProjectionUtils.drawRect(g2d, left, top, width, height);
        g2d.setStroke(oldstroke);
    }

    static BasicStroke getSquareMiterStroke(Stroke ostroke) {
        return ProjectionUtils.getSquareMiterStroke(((BasicStroke)ostroke).getLineWidth());
    }

    static BasicStroke getSquareMiterStroke(float width) {
        return new BasicStroke(width, 2, 0);
    }

    static BasicStroke getButtRoundStroke(Stroke ostroke) {
        return ProjectionUtils.getButtRoundStroke(((BasicStroke)ostroke).getLineWidth());
    }

    static BasicStroke getButtRoundStroke(float width) {
        return new BasicStroke(width, 0, 1);
    }

    static final void drawBezier(Graphics2D g2d, Point2D.Double ... points) {
        ArrayList<Point2D.Double> segment = new ArrayList<Point2D.Double>(points.length);
        Point2D.Double prevPt = null;
        for (Point2D.Double point : points) {
            if (point == null) {
                if (prevPt != null) {
                    ProjectionUtils.drawBezier(g2d, segment);
                    segment.clear();
                }
                prevPt = null;
                continue;
            }
            segment.add(point);
            prevPt = new Point2D.Double(point.x, point.y);
        }
        ProjectionUtils.drawBezier(g2d, segment);
    }

    static final void drawBezier(Graphics2D g2d, ArrayList<Point2D.Double> points) {
        if (points.size() < 2) {
            return;
        }
        Point2D.Double first = points.get(0);
        Point2D.Double last = points.get(points.size() - 1);
        boolean closed = first.x == last.x && first.y == last.y;
        Bezier b = new Bezier(closed, points);
        if (b != null) {
            b.draw(g2d);
        }
    }
}

