/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjListParameter
extends ProjExtraParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object[] choices_;
    private int index_;
    private int defaultIndex_;

    public ProjListParameter(String description, String label, Class<? extends ProjListEnum> lclass, int index) {
        super(description, label, null);
        this.choices_ = lclass.getEnumConstants();
        if (this.choices_ == null) {
            throw new IllegalArgumentException("List class does not procide enum cosntants");
        }
        this.defaultIndex_ = index;
        this.setIndex(index);
    }

    public Object[] getChoices() {
        return this.choices_;
    }

    @Override
    public void reset() {
        this.setIndex(this.defaultIndex_);
    }

    public Object getDefault() {
        return this.choices_[this.defaultIndex_];
    }

    public void setDefault(String cname) {
        for (int i = 0; i < this.choices_.length; ++i) {
            if (!this.choices_[i].toString().equalsIgnoreCase(cname)) continue;
            this.defaultIndex_ = i;
            break;
        }
    }

    @Override
    public Object getDefaultObject() {
        return this.choices_[this.defaultIndex_];
    }

    public Object getValue() {
        return this.choices_[this.index_];
    }

    @Override
    public Object getValueObject() {
        return this.choices_[this.index_];
    }

    @Override
    public void setValue(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        if (value instanceof ProjListEnum) {
            this.setValue(((ProjListEnum)value).name());
        } else if (value instanceof String) {
            this.setValue(value.toString());
        } else if (value instanceof Integer) {
            this.setValue((Integer)value);
        } else {
            LOGGER.warn("No prepared to set a list param of class {}", (Object)value.getClass());
        }
    }

    @Override
    public void setValue(String value) {
        for (int i = 0; i < this.choices_.length; ++i) {
            if (!((ProjListEnum)this.choices_[i]).matches(value)) continue;
            this.setIndex(i);
            return;
        }
        LOGGER.warn("Could not find list item matching {}", (Object)value);
    }

    public void setValue(int index) throws IllegalArgumentException {
        this.setIndex(index);
    }

    public int getIndex() {
        return this.index_;
    }

    public void setIndex(int index) throws IllegalArgumentException {
        if (index == this.index_) {
            return;
        }
        if (this.index_ < 0 || this.index_ >= this.choices_.length) {
            throw new IndexOutOfBoundsException("Choice out of list index range.");
        }
        this.index_ = index;
        this.fireChange();
    }
}

