/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Philbrick
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Philbrick Sinu-Mollweide";
    public static final int PROPERTIES = 2;
    private static final double JOIN_LAT = -40.736666666666;
    private static final double JOIN_LAT_RAD = Math.toRadians(-40.736666666666);
    private static final double YSHIFT = 0.0528;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private LonLatRotator rotMatrices_ = new LonLatRotator(0.0, 0.0, 0.0);

    public Philbrick(int width, int height) {
        this(width, height, 0, 0);
    }

    public Philbrick(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, 2.8284271247461903, 1.5707963267948966);
        this.rotMatrices_.setAngles(0.0, 55.0);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ == null) {
            this.rotMatrices_ = new LonLatRotator(0.0, 0.0, 0.0);
        }
        this.rotMatrices_.setAngles(lon, 55.0);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        return this.transformLL2XYIgnoreMargins2(lon, lat, true);
    }

    private Point2D.Double transformLL2XYIgnoreMargins2(double lon, double lat, boolean rotate) {
        double x;
        double y;
        double latP;
        double lonP;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (rotate) {
            double[] llP = this.rotMatrices_.rotate(lon, lat);
            lonP = llP[0];
            latP = llP[1];
        } else {
            lonP = this.lonToLambda(lon);
            latP = lat;
        }
        double lambdaRad = Math.toRadians(lonP);
        double phiRad = Math.toRadians(latP);
        if (latP > 89.99999) {
            y = 1.4142135623730951;
            x = 0.0;
            y += 0.0528;
        } else if (latP > -40.736666666666) {
            double piSinPhi = Math.PI * Math.sin(phiRad);
            double thetaRad = phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                double twoThetaRad = 2.0 * thetaRad;
                double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = 1.4142135623730951 * Math.sin(thetaRad);
            x = lambdaRad * 1.4142135623730951 * Math.cos(thetaRad) * 0.6366197723675814;
            y += 0.0528;
        } else {
            y = phiRad;
            x = lambdaRad * Math.cos(phiRad);
        }
        y += 0.0264;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_ - 0.0264;
        if (yOverRS > JOIN_LAT_RAD) {
            double sinTheta = (yOverRS -= 0.0528) * 0.7071067811865476;
            if (sinTheta > 1.0) {
                return null;
            }
            double thetaRad = Math.asin(sinTheta);
            phiPRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
            xFactor = 1.5707963267948966 * this.invRS_ * 0.7071067811865476 / Math.cos(thetaRad);
        } else {
            phiPRad = yOverRS;
            if (phiPRad < -1.5707963267948966) {
                return null;
            }
            xFactor = this.invRS_ / Math.cos(phiPRad);
        }
        double lambdaPRad = x * xFactor;
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Philbrick philbrick = this;
        synchronized (philbrick) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiPRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - 0.0264;
                if (yOverRS > JOIN_LAT_RAD) {
                    double sinTheta = (yOverRS -= 0.0528) * 0.7071067811865476;
                    if (sinTheta > 1.0) break;
                    double thetaRad = Math.asin(sinTheta);
                    phiPRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
                    xFactor = 1.5707963267948966 * this.invRS_ * 0.7071067811865476 / Math.cos(thetaRad);
                } else {
                    phiPRad = yOverRS;
                    if (phiPRad < -1.5707963267948966) continue;
                    xFactor = this.invRS_ / Math.cos(phiPRad);
                }
                double phiP = Math.toDegrees(phiPRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaPRad = x * xFactor;
                    if (Math.abs(lambdaPRad) > Math.PI) continue;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
                    ll[0] = ll[0] - this.lambdaC_;
                    this.setInvPoints(ix, iy, ll[0], ll[1]);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBeziers();
        if (curves != null) {
            curves[0].draw(g2d);
            curves[1].draw(g2d);
        }
    }

    private Bezier[] makeOuterBeziers() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 270;
        double fact = 0.6666666666666666;
        Point2D.Double[] dotsE = new Point2D.Double[271];
        Point2D.Double[] dotsW = new Point2D.Double[271];
        for (int j = 0; j <= 270; ++j) {
            double lat = -90.0 + 0.6666666666666666 * (double)j;
            Point2D.Double dot = this.transformLL2XYIgnoreMargins2(edgeLon, lat, false);
            if (dot == null) {
                LOGGER.debug("Got null XY for border lon {}, lat {}", (Object)edgeLon, (Object)lat);
                break;
            }
            dotsE[j] = dot;
            dotsW[j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

