/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class McBrydeThomas1
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas I";
    private static final double CONST_P = 1.48875143;
    private static final double CONST_Q = 1.36508592;
    private static final double INV_P = 0.6717038048453797;
    private static final double INV_Q = 0.7325546219098062;
    private static final double Q_OVER_P = 0.9169334064048557;
    private static final double P_OVER_Q = 1.0905917409213333;
    private static final double MAX_X_OVER_RS = 2.8806312533925587;
    private static final double MAX_Y_OVER_RS = 1.48875143 * Math.sin(1.150694109272548);

    public McBrydeThomas1(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomas1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.8806312533925587, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiOverQ = phiRad * 0.7325546219098062;
        double x = 0.9169334064048557 * this.lonToLambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = 1.48875143 * Math.sin(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.36508592 * Math.asin(yOverRS * 0.6717038048453797);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double d = lambdaRad = phiRad == 0.0 ? xOverRS * 1.0905917409213333 : xOverRS * 1.0905917409213333 * Math.cos(phiRad * 0.7325546219098062) / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeThomas1 mcBrydeThomas1 = this;
        synchronized (mcBrydeThomas1) {
            double y;
            double yOverRS;
            double phiRad;
            double pOverQRS = 1.0905917409213333 * this.invRS_;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 1.36508592 * Math.asin((yOverRS = (y = (double)iy + 0.5) * this.invRS_) * 0.6717038048453797)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = pOverQRS * Math.cos(phiRad * 0.7325546219098062) / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

