/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class McBrydeS2
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde S2";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 49.2666666667;
    private static final double JOIN_LAT_RAD = Math.toRadians(49.2666666667);
    private static final double YSHIFT = 0.084398;
    private static final double TWO_PLUS_PI = 5.141592653589793;
    private static final double TERM1 = Math.sqrt(5.141592653589793);
    private static final double INV_TERM1 = 1.0 / TERM1;
    private static final double TWO_OVER_TERM1 = 2.0 * INV_TERM1;
    private static final double TERM3 = 0.5 * TWO_OVER_TERM1 * TWO_OVER_TERM1;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = INV_TERM1 * Math.PI - 0.084398;
    private double joinYRS_;

    public McBrydeS2(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeS2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.MCBCONT.toString());
        interrupt.setValue(Interruption.MCBCONT.toString());
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.joinYRS_ = JOIN_LAT_RAD * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double thetaRad = 0.0;
        double phiRad = Math.toRadians(lat);
        if (absLat > 49.2666666667) {
            double phiFactor = 2.5707963267948966 * Math.sin(phiRad);
            thetaRad = Math.toRadians(lat);
            for (int iter = 0; iter < 33; ++iter) {
                double func = thetaRad + Math.sin(thetaRad) - phiFactor;
                double dfunc = 1.0 + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = 2.0 * thetaRad * INV_TERM1;
            y = lat > 0.0 ? (y -= 0.084398) : (y += 0.084398);
        } else {
            y = phiRad;
        }
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon);
            dx = absLat > 49.2666666667 ? (dx *= (1.0 + Math.cos(thetaRad)) * INV_TERM1) : (dx *= Math.cos(phiRad));
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            x = absLat > 49.2666666667 ? (x *= (1.0 + Math.cos(thetaRad)) * INV_TERM1) : (x *= Math.cos(phiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinYRS_) {
            double sinTheta;
            double yOverRS = Math.abs(y) * this.invRS_ + 0.084398;
            double thetaRad = yOverRS / TWO_OVER_TERM1;
            phiRad = Math.asin((thetaRad + (sinTheta = Math.sin(thetaRad))) * TERM3);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = 2.0 * this.invRS_ / (TWO_OVER_TERM1 * (1.0 + Math.cos(thetaRad)));
        } else {
            phiRad = y * this.invRS_;
            xFactor = this.invRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double twoOverRS = 2.0 * this.invRS_;
        McBrydeS2 mcBrydeS2 = this;
        synchronized (mcBrydeS2) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (Math.abs(y) > this.joinYRS_) {
                    double yOverRS = y * this.invRS_;
                    yOverRS = y > 0.0 ? (yOverRS += 0.084398) : (yOverRS -= 0.084398);
                    double thetaRad = yOverRS / TWO_OVER_TERM1;
                    double sinTheta = Math.sin(thetaRad);
                    phiRad = Math.asin((thetaRad + sinTheta) * TERM3);
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = twoOverRS / (TWO_OVER_TERM1 * (1.0 + Math.cos(thetaRad)));
                } else {
                    phiRad = y * this.invRS_;
                    xFactor = this.invRS_ / Math.cos(phiRad);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

