/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.Circles;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class MaurerS159
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "Maurer SNo. 159 Full Globular";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.9634954084936207;
    private static final double PI_OVER_8 = 0.39269908169872414;
    private static final double THREE_PI_OVER_8 = 1.1780972450961724;
    private static final double FIVE_PI_OVER_8 = 1.9634954084936207;
    private static final double LOBE_X_UNSCALED = 1.1780972450961724;
    private static final double OUTER_ARC_RAD = 2.2142974356;
    private static final double TWO_OUTER_ARC_OVER_PI = 1.4096655294057912;

    public MaurerS159(int width, int height) {
        this(width, height, 0, 0);
    }

    public MaurerS159(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, 1.9634954084936207);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5) {
            x = 0.0;
            y = absPhiRad;
        } else if (absPhiRad < 1.0E-5) {
            x = absLambdaRad;
            y = 0.0;
        } else if (absPhiRad > 1.5707963266948965) {
            x = 0.0;
            y = 1.5707963267948966;
        } else {
            double thetaRad = absPhiRad * 1.4096655294057912;
            double xa = 1.1780972450961724 + 1.9634954084936207 * Math.cos(thetaRad);
            double ya = 1.9634954084936207 * Math.sin(thetaRad);
            if (absLambdaRad > 3.1415426535897932) {
                x = xa;
                y = ya;
            } else {
                double rho0 = (Math.PI * Math.PI + 4.0 * absLambdaRad * absLambdaRad) / (8.0 * absLambdaRad);
                double x0 = absLambdaRad - rho0;
                double bb = ya - absPhiRad;
                double rho1 = 0.5 * xa * (xa / bb + bb / xa);
                double y1 = absPhiRad + rho1;
                Point2D.Double[] ipts = Circles.getIntersectionPoints(x0, 0.0, rho0, 0.0, y1, rho1);
                if (ipts == null || ipts.length != 2) {
                    return null;
                }
                if (ipts[0].x > ipts[1].x) {
                    x = ipts[0].x;
                    y = ipts[0].y;
                } else {
                    x = ipts[1].x;
                    y = ipts[1].y;
                }
            }
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absX * this.invRS_;
        double yOverRS = absY * this.invRS_;
        double[] lambdaPhi = this.transformUnscaledXYtoLambdaPhi(xOverRS, yOverRS);
        if (lambdaPhi == null) {
            return null;
        }
        double phiRad = lambdaPhi[1];
        if (Double.isNaN(phiRad) || phiRad > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = lambdaPhi[0];
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        MaurerS159 maurerS159 = this;
        synchronized (maurerS159) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y * this.invRS_);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = Math.abs(x * this.invRS_);
                    double[] lambdaPhi = this.transformUnscaledXYtoLambdaPhi(xOverRS, yOverRS);
                    if (lambdaPhi == null) {
                        if (!(yOverRS < 1.5707963267948966) && !(xOverRS > 1.1780972450961724)) continue;
                        continue block3;
                    }
                    double lambdaRad = lambdaPhi[0];
                    double phiRad = lambdaPhi[1];
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] transformUnscaledXYtoLambdaPhi(double x, double y) {
        if (x > Math.PI || y > 1.9634954084936207) {
            return null;
        }
        double dzx = x - 1.1780972450961724;
        double ySq = y * y;
        if (dzx * dzx + ySq > 3.8553142191755305) {
            return null;
        }
        if (x < 1.0E-10) {
            if (y > 1.5707963267948966) {
                return null;
            }
            return new double[]{x, y};
        }
        if (y < 1.0E-10) {
            return new double[]{0.0, y};
        }
        double xSq = x * x;
        double xSqPlusYSq = xSq + ySq;
        double x0 = 0.5 / x * (xSqPlusYSq - 2.4674011002723395);
        double rho0Sq = x0 * x0 + 2.4674011002723395;
        double rho0 = Math.sqrt(rho0Sq);
        double lambdaRad = x0 + rho0;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = 0.75 * y;
        for (int i = 0; i < 33; ++i) {
            double thetaRad = phiRad * 1.4096655294057912;
            double dthetaDphi = 1.4096655294057912;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double xa = 1.1780972450961724 + 1.9634954084936207 * cosTheta;
            double ya = 1.9634954084936207 * sinTheta;
            if (xa < x) {
                phiRad -= Math.toRadians(1.0);
                continue;
            }
            double aa = xa;
            double bb = ya - phiRad;
            double aSqPlusBSq = aa * aa + bb * bb;
            double invB = 1.0 / bb;
            double inv2B = 0.5 * invB;
            double rp = inv2B * aSqPlusBSq;
            double rpSqMinusXSq = rp * rp - xSq;
            double sqrtRp2MinusX2 = Math.sqrt(rpSqMinusXSq);
            double daDphi = -1.9634954084936207 * sinTheta * 1.4096655294057912;
            double dbDphi = 1.9634954084936207 * cosTheta * 1.4096655294057912 - 1.0;
            double drpDphi = inv2B * (2.0 * (aa * daDphi + bb * dbDphi) - invB * aSqPlusBSq * dbDphi);
            double func = phiRad + rp - sqrtRp2MinusX2 - y;
            double dfunc = 1.0 + (1.0 - 0.5 / sqrtRp2MinusX2 * (2.0 * rp)) * drpDphi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        GraphicUtils.drawCircularArc(g2d, this.outCenterX_, (double)this.outCenterY_ - 1.5707963267948966 * this.rS_, (double)this.outCenterX_ + Math.PI * this.rS_, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ + 1.5707963267948966 * this.rS_);
        GraphicUtils.drawCircularArc(g2d, this.outCenterX_, (double)this.outCenterY_ + 1.5707963267948966 * this.rS_, (double)this.outCenterX_ - Math.PI * this.rS_, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ - 1.5707963267948966 * this.rS_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - Math.PI * this.rS_, this.outCenterY_, (double)this.outCenterX_ + Math.PI * this.rS_, this.outCenterY_);
        } else {
            double lon1 = this.lambdaC_ - 179.99999;
            double lon2 = this.lambdaC_;
            double lon3 = this.lambdaC_ + 179.99999;
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
            Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
            Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda = MapUtils.normalize360(lon - this.lambdaC_);
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, this.outCenterX_, (double)this.outCenterY_ - 1.5707963267948966 * this.rS_, this.outCenterX_, (double)this.outCenterY_ + 1.5707963267948966 * this.rS_);
        } else {
            if (absLambda > 179.99999) {
                return;
            }
            double dlonRad = Math.toRadians(lambda);
            if (dlonRad > Math.PI) {
                dlonRad -= Math.PI * 2;
            }
            GraphicUtils.drawCircularArc(g2d, this.outCenterX_, (double)this.outCenterY_ - 1.5707963267948966 * this.rS_, (double)this.outCenterX_ + dlonRad * this.rS_, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ + 1.5707963267948966 * this.rS_);
        }
    }
}

