/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Larrivee
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Larriv\u00e9e";
    public static final int PROPERTIES = 0;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.5650996603237277;
    private static final double PI_OVER_SQRT2 = 2.221441469079183;

    public Larrivee(int width, int height) {
        this(width, height, 0, 0);
    }

    public Larrivee(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, Math.PI, 2.5650996603237277);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = 0.5 * lambdaRad * (1.0 + Math.sqrt(Math.cos(phiRad)));
        double y = phiRad / (Math.cos(0.5 * phiRad) * Math.cos(lambdaRad / 6.0));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double yOverRS = absY * this.invRS_;
        double lambdaRad0 = 0.0;
        double phiRad0 = 0.0;
        if (yOverRS < 2.221441469079183) {
            phiRad0 = 1.5707963267948966 * (yOverRS / 2.221441469079183);
            lambdaRad0 = 1.0E-5;
        } else {
            phiRad0 = 1.5707863267948965;
            lambdaRad0 = 6.0 * Math.acos(2.221441469079183 / yOverRS);
            if (absX < this.rS_ * lambdaRad0 * 0.5) {
                return null;
            }
            lambdaRad0 += 1.0E-5;
        }
        double[] llRad = this.iterateXY2LLRad(absX, absY, lambdaRad0, phiRad0);
        if (llRad == null || llRad[1] > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        Larrivee larrivee = this;
        synchronized (larrivee) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double[] llRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                int minX = 0;
                if (yOverRS < 2.221441469079183) {
                    phiRad = 1.5707963267948966 * (yOverRS / 2.221441469079183);
                    lambdaRad = 1.0E-5;
                } else {
                    phiRad = 1.5707863267948965;
                    lambdaRad = 6.0 * Math.acos(2.221441469079183 / yOverRS);
                    minX = (int)(this.rS_ * lambdaRad * 0.5) + 1;
                    lambdaRad += 1.0E-5;
                }
                for (int ix = minX; ix < this.dxMax_ && (llRad = this.iterateXY2LLRad(x = (double)ix + 0.5, y, lambdaRad, phiRad)) != null; ++ix) {
                    lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] iterateXY2LLRad(double x, double y, double lambdaRad0, double phiRad0) {
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double f1 = 0.0;
        double f2 = 0.0;
        double df1dLambda = 0.0;
        double df1dPhi = 0.0;
        double df2dLambda = 0.0;
        double df2dPhi = 0.0;
        double denom = 0.0;
        double dphi = 0.0;
        double dlambda = 0.0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRadOver2 = 0.5 * phiRad;
            double lambdaRadOver6 = lambdaRad / 6.0;
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double cosPhiOver2 = Math.cos(phiRadOver2);
            double sinPhiOver2 = Math.sin(phiRadOver2);
            double cosLambdaOver6 = Math.cos(lambdaRadOver6);
            double sinLambdaOver6 = Math.sin(lambdaRadOver6);
            double invCosPhiOver2 = 1.0 / cosPhiOver2;
            double invCosLambdaOver6 = 1.0 / cosLambdaOver6;
            double sqrtCosPhi = Math.sqrt(cosPhi);
            double onePlusSqrtCosPhi = 1.0 + sqrtCosPhi;
            f1 = 0.5 * lambdaRad * onePlusSqrtCosPhi - xOverRS;
            f2 = phiRad * invCosPhiOver2 * invCosLambdaOver6 - yOverRS;
            df1dPhi = -0.25 * lambdaRad * sinPhi / sqrtCosPhi;
            df1dLambda = 0.5 * onePlusSqrtCosPhi;
            df2dPhi = (1.0 + 0.5 * phiRad * sinPhiOver2 * invCosPhiOver2) * invCosPhiOver2 * invCosLambdaOver6;
            df2dLambda = phiRad * invCosPhiOver2 * (sinLambdaOver6 / 6.0) * invCosLambdaOver6 * invCosLambdaOver6;
            denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (!(Math.abs(dphi) < 1.0E-5) || !(Math.abs(dlambda) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

