/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterruptedPseudocylindric
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x1000008;
    private Interruption interruption_ = Interruption.UNINT;
    private final ProjListParameter interruptParam_;
    protected double cylindricLatLimit_;

    public InterruptedPseudocylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        if (!this.hasProperty(8) || !this.hasProperty(0x1000000)) {
            throw new IllegalArgumentException("Subclassed projection does not specify INTERRUPTED & PSEUDOCYLINDRIC properties.");
        }
        this.interruptParam_ = new ProjListParameter("Scheme for interruption lobes/gores", "Format", Interruption.class, 0);
        this.addParameter(this.interruptParam_);
    }

    @Override
    public void setCenter(double lon, double lat) {
        if (this.interruption_ == null || this.interruption_ == Interruption.UNINT) {
            super.setCenter(lon, 0.0);
        } else {
            super.setCenter(this.interruption_.getCenterLongitude(), 0.0);
        }
    }

    public ProjListParameter getInterruptionParameter() {
        return this.interruptParam_;
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.interruptParam_) {
            this.setInterruption(this.interruptParam_.getIndex());
        } else {
            LOGGER.trace("Param not handled by InterruptedPseudocylindric, Perhaps a subclass does so.");
        }
        this.autoscale();
        if (!this.isRecenterableLon()) {
            this.setCenter(999.0, 0.0);
        }
    }

    private void setInterruption(int choice) {
        this.interruption_ = Interruption.values()[choice];
    }

    public boolean isShowingInterrupted() {
        return this.interruption_ != Interruption.UNINT;
    }

    @Override
    public boolean isRecenterableLon() {
        return this.interruption_ == Interruption.UNINT;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.isShowingInterrupted()) {
            this.drawBorderLinesInterrupted(g2d);
        } else {
            this.drawBorderLinesUninterrupted(g2d);
        }
    }

    private void drawBorderLinesInterrupted(Graphics2D g2d) {
        Point2D.Double dot2;
        Point2D.Double dot1;
        int ii;
        double[][] north = this.interruption_.getGores()[0];
        double[][] south = this.interruption_.getGores()[1];
        boolean hasPoleLine = false;
        Point2D.Double dot12 = this.transformLL2XY(north[0][0], 90.0);
        Point2D.Double dot22 = this.transformLL2XY(north[0][2], 90.0);
        hasPoleLine = Math.abs(dot12.x - dot22.x) > 1.0E-5;
        Path2D.Double polePath = new Path2D.Double();
        for (ii = 0; ii < north.length; ++ii) {
            if (ii == 0 || this.cylindricLatLimit_ == 0.0) {
                this.drawBorderMeridian(g2d, north[ii][0] + 1.0E-5, 0.0, 90.0);
            } else {
                this.drawBorderMeridian(g2d, north[ii][0] + 1.0E-5, this.cylindricLatLimit_, 90.0);
            }
            if (ii == north.length - 1 || this.cylindricLatLimit_ == 0.0) {
                this.drawBorderMeridian(g2d, north[ii][2] - 1.0E-5, 0.0, 90.0);
            } else {
                this.drawBorderMeridian(g2d, north[ii][2] - 1.0E-5, this.cylindricLatLimit_, 90.0);
            }
            if (!hasPoleLine) continue;
            dot1 = this.transformLL2XY(north[ii][0] + 1.0E-5, 89.99999);
            dot2 = this.transformLL2XY(north[ii][2] - 1.0E-5, 89.99999);
            polePath.moveTo(dot1.x, dot1.y);
            polePath.lineTo(dot2.x, dot2.y);
        }
        for (ii = 0; ii < south.length; ++ii) {
            if (ii == 0 || this.cylindricLatLimit_ == 0.0) {
                this.drawBorderMeridian(g2d, south[ii][0] + 1.0E-5, -90.0, 0.0);
            } else {
                this.drawBorderMeridian(g2d, south[ii][0] + 1.0E-5, -90.0, -this.cylindricLatLimit_);
            }
            if (ii == south.length - 1 || this.cylindricLatLimit_ == 0.0) {
                this.drawBorderMeridian(g2d, south[ii][2] - 1.0E-5, -90.0, 0.0);
            } else {
                this.drawBorderMeridian(g2d, south[ii][2] - 1.0E-5, -90.0, -this.cylindricLatLimit_);
            }
            if (!hasPoleLine) continue;
            dot1 = this.transformLL2XY(south[ii][0] + 1.0E-5, -89.99999);
            dot2 = this.transformLL2XY(south[ii][2] - 1.0E-5, -89.99999);
            polePath.moveTo(dot1.x, dot1.y);
            polePath.lineTo(dot2.x, dot2.y);
        }
        if (hasPoleLine) {
            g2d.draw(polePath);
        }
    }

    private void drawBorderLinesUninterrupted(Graphics2D g2d) {
        try {
            double rightLon = this.lambdaC_ + 179.99999;
            double leftLon = this.lambdaC_ - 179.99999;
            int np = 105;
            double fact = 0.8571428571428571;
            Point2D.Double[] dotsE = new Point2D.Double[211];
            Point2D.Double[] dotsW = new Point2D.Double[211];
            for (int j = 0; j <= 105; ++j) {
                double jj = 0.8571428571428571 * (double)j;
                Point2D.Double dot = this.transformLL2XY(rightLon, jj);
                dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
                dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
                dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
                dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            }
            new Bezier(false, dotsE).draw(g2d);
            new Bezier(false, dotsW).draw(g2d);
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ - 179.99999, 90.0);
            if (dot1.x != dot2.x) {
                Path2D.Double polePath = new Path2D.Double();
                dot1 = this.transformLL2XY(leftLon, 89.99999);
                dot2 = this.transformLL2XY(rightLon, 89.99999);
                polePath.moveTo(dot1.x, dot1.y);
                polePath.lineTo(dot2.x, dot2.y);
                dot1 = this.transformLL2XY(leftLon, -89.99999);
                dot2 = this.transformLL2XY(rightLon, -89.99999);
                polePath.moveTo(dot1.x, dot1.y);
                polePath.lineTo(dot2.x, dot2.y);
                g2d.draw(polePath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawBorderMeridian(Graphics2D g2d, double lon, double lat1, double lat2) {
        double minLat = Math.min(lat1, lat2);
        double maxLat = Math.max(lat1, lat2);
        double dlat = 0.5;
        int steps = (int)(Math.abs(maxLat - minLat) / 0.5);
        PointLL[] points = new PointLL[steps + 1];
        for (int jj = 0; jj <= steps; ++jj) {
            double lat = minLat + 0.5 * (double)jj;
            if (lat >= 90.0) {
                lat = 89.99999;
            }
            if (lat <= -90.0) {
                lat = -89.99999;
            }
            points[jj] = new PointLL(lon, lat);
        }
        ProjectionUtils.drawBezier(g2d, this.translatePath(points));
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Path2D.Double path = new Path2D.Double();
        if (this.isRecenterableLon() || lat == 0.0 || Math.abs(lat) <= this.cylindricLatLimit_) {
            double leftEdge = this.lambdaC_ - 179.99999;
            double rightEdge = this.lambdaC_ + 179.99999;
            Point2D.Double dot1 = this.transformLL2XY(leftEdge, lat);
            Point2D.Double dot2 = this.transformLL2XY(rightEdge, lat);
            if (dot1 != null && dot2 != null) {
                path.moveTo(dot1.x, dot1.y);
                path.lineTo(dot2.x, dot2.y);
            }
        } else if (lat > 0.0) {
            double[][] north = this.interruption_.getGores()[0];
            for (int ii = 0; ii < north.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(north[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(north[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo(dot1.x, dot1.y);
                path.lineTo(dot2.x, dot2.y);
            }
        } else {
            double[][] south = this.interruption_.getGores()[1];
            for (int ii = 0; ii < south.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(south[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(south[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo(dot1.x, dot1.y);
                path.lineTo(dot2.x, dot2.y);
            }
        }
        g2d.draw(path);
    }

    protected double getLongitudeForX(double x, double xFactorAtLat, double xFactorAtEq, boolean north) {
        double clon;
        double cx;
        double dclon;
        if (this.isRecenterableLon()) {
            double lambdaRad = x * xFactorAtLat;
            if (Math.abs(lambdaRad) > Math.PI) {
                return Double.NaN;
            }
            return this.lambdaC_ + Math.toDegrees(lambdaRad);
        }
        double elon = Math.toDegrees(x * xFactorAtEq);
        if (Math.abs(elon) > 180.0) {
            return Double.NaN;
        }
        double[] gore = this.getGore(elon += this.lambdaC_, north ? 1.0 : -1.0);
        double dlon1 = gore[1] - gore[0];
        double dlon2 = gore[2] - gore[1];
        if (dlon1 < 0.0) {
            dlon1 += 360.0;
        }
        if (dlon2 < 0.0) {
            dlon2 += 360.0;
        }
        if ((dclon = Math.toDegrees((x - (cx = this.lonToLambdaRad(clon = gore[1]) / xFactorAtEq)) * xFactorAtLat)) + dlon1 < 0.0) {
            return Double.NaN;
        }
        if (dclon - dlon2 > 0.0) {
            return Double.NaN;
        }
        return dclon + clon;
    }

    protected double[] getGore(double lon, double lat) {
        double nlon = MapUtils.normalizeMP180(lon);
        if (lat >= 0.0) {
            double[][] north = this.interruption_.getGores()[0];
            for (int i = 0; i < north.length; ++i) {
                boolean wraps;
                boolean bl = wraps = north[i][2] < north[i][0];
                if (!(wraps ? nlon >= north[i][0] || nlon <= north[i][2] : nlon >= north[i][0] && nlon <= north[i][2])) continue;
                return north[i];
            }
            return north[0];
        }
        double[][] south = this.interruption_.getGores()[1];
        for (int i = 0; i < south.length; ++i) {
            boolean wraps;
            boolean bl = wraps = south[i][2] < south[i][0];
            if (!(wraps ? nlon >= south[i][0] || nlon <= south[i][2] : nlon >= south[i][0] && nlon <= south[i][2])) continue;
            return south[i];
        }
        return south[0];
    }

    protected void setInvPoint(int ix, int iy, double lon, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, phi);
    }
}

