/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HammerOblique
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hammer (Oblique)";
    public static final int PROPERTIES = 0xA02020;
    private static final double CSUBX = 2.0;
    private static final double CSUBY = 1.0;
    private static final double CSUBX_B = Math.sqrt(1.75);
    private static final double CSUBY_B = 1.0 / CSUBX_B;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private LonLatRotator rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
    private double cSubX_ = 2.0;
    private double cSubY_ = 1.0;
    private double invCx_;
    private double invCy_;
    private double inv2RS_;
    private double invRSCX_;
    private double invRSCY_;
    private final ProjDoubleParameter rotateParam_ = new ProjDoubleParameter("Third (plagal) rotation", "Third rotation", "\u00b0 ", this.xAxisRotation_, -360.0, 360.0, true, true);
    private double xAxisRotation_;
    private final ProjBooleanParameter brieseParam_ = new ProjBooleanParameter("Apply Briesemeister's scaling", "Apply Briesemeister's scaling", false);

    public HammerOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public HammerOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA02020, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        this.addParameter(this.rotateParam_);
        this.addParameter(this.brieseParam_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat, this.xAxisRotation_);
        }
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setXAxisRotation(this.rotateParam_.getValue());
            this.setBriesemeisterScaling(this.brieseParam_.isSelected());
        } else if (p == this.rotateParam_) {
            this.setXAxisRotation(this.rotateParam_.getValue());
        } else if (p == this.brieseParam_) {
            this.setBriesemeisterScaling(this.brieseParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setXAxisRotation(double angle) {
        this.xAxisRotation_ = angle;
        this.rotMatrices_.setAngles(this.lambdaC_, this.phiC_, this.xAxisRotation_);
        this.autoscale();
    }

    private void setBriesemeisterScaling(boolean b) {
        if (b) {
            this.cSubX_ = CSUBX_B;
            this.cSubY_ = CSUBY_B;
        } else {
            this.cSubX_ = 2.0;
            this.cSubY_ = 1.0;
        }
        this.invCx_ = 1.0 / this.cSubX_;
        this.invCy_ = 1.0 / this.cSubY_;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(this.cSubX_ * 1.4142135623730951, this.cSubY_ * 1.4142135623730951);
    }

    @Override
    protected final void finishScaling() {
        this.inv2RS_ = 0.5 * this.invRS_;
        this.invRSCX_ = this.invRS_ * this.invCx_;
        this.invRSCY_ = this.invRS_ * this.invCy_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double halfLambdaPRad = 0.5 * Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double cosBeta = cosPhiP * Math.cos(halfLambdaPRad);
        double betaTerm = Math.sqrt(0.5 * (1.0 + cosBeta));
        if (betaTerm < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinPhiP = Math.sin(phiPRad);
        double invBetaTerm = 1.0 / betaTerm;
        double x = this.cSubX_ * cosPhiP * Math.sin(halfLambdaPRad) * invBetaTerm;
        double y = this.cSubY_ * sinPhiP * invBetaTerm;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double sinHalfBeta = this.inv2RS_ * Math.hypot(x * this.invCx_, y * this.invCy_);
        double halfBetaRad = Math.asin(sinHalfBeta);
        double cosHalfBeta = Math.cos(halfBetaRad);
        double phiPRad = Math.asin(y * cosHalfBeta * this.invRSCY_);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double cosBeta = Math.cos(2.0 * halfBetaRad);
        double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.invRSCX_, cosBeta);
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        HammerOblique hammerOblique = this;
        synchronized (hammerOblique) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCY = y * this.invCy_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaPRad;
                    double x = (double)ix + 0.5;
                    double sinHalfBeta = this.inv2RS_ * Math.hypot(x * this.invCx_, yOverCY);
                    double halfBetaRad = Math.asin(sinHalfBeta);
                    double cosHalfBeta = Math.cos(halfBetaRad);
                    double cosBeta = Math.cos(2.0 * halfBetaRad);
                    double phiPRad = Math.asin(y * cosHalfBeta * this.invRSCY_);
                    if (phiPRad > 1.5707963267948966) continue block3;
                    double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.invRSCX_, cosBeta);
                    if (lambdaPRad > Math.PI) continue block3;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double phiP = Math.toDegrees(phiPRad);
                    double[] llTR = this.rotMatrices_.inverse(lambdaP, phiP);
                    double[] llBR = this.rotMatrices_.inverse(lambdaP, -phiP);
                    double[] llBL = this.rotMatrices_.inverse(-lambdaP, -phiP);
                    double[] llTL = this.rotMatrices_.inverse(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }

    private void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double absPhiC = Math.abs(this.phiC_);
        if (lat == 0.0 && absPhiC < 1.0E-5 && (Math.abs(this.xAxisRotation_) == 90.0 || Math.abs(this.xAxisRotation_) == 270.0)) {
            Point2D.Double p1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 89.99999, 0.0);
            Point2D.Double p2 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 89.99999, 0.0);
            if (p1 != null && p2 != null) {
                GraphicUtils.drawLine(g2d, p1, p2);
            }
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absPhiC = Math.abs(this.phiC_);
        if (absPhiC > 89.99999) {
            double rotlon;
            double d = rotlon = this.phiC_ > 0.0 ? MapUtils.normalizeMP180(lon - this.lambdaC_ + this.xAxisRotation_) : MapUtils.normalizeMP180(lon - this.lambdaC_ - this.xAxisRotation_);
            if (rotlon % 90.0 == 0.0) {
                double phiCC = this.phiC_ > 0.0 ? 89.99999 : -89.99999;
                Point2D.Double p1 = null;
                Point2D.Double p2 = null;
                if (rotlon % 180.0 == 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, phiCC);
                    p2 = this.transformLL2XYIgnoreMargins(lon, 1.0E-5);
                } else {
                    p1 = this.transformLL2XYIgnoreMargins(lon, phiCC);
                    p2 = this.transformLL2XYIgnoreMargins(lon, -phiCC);
                }
                GraphicUtils.drawLine(g2d, p1, p2);
                return;
            }
        }
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (this.xAxisRotation_ % 90.0 == 0.0 && absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5 && this.xAxisRotation_ % 90.0 == 0.0) {
            Point2D.Double p2;
            Point2D.Double p1;
            double modulus360 = MapUtils.normalize360(this.xAxisRotation_) % 360.0;
            if (modulus360 == 0.0 || modulus360 == 180.0) {
                if (this.phiC_ == 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, -89.99999);
                    p2 = this.transformLL2XYIgnoreMargins(lon, 89.99999);
                } else if (this.phiC_ > 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, -90.0 + this.phiC_ + 1.0E-5);
                    p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, 90.0 - this.phiC_ + 1.0E-5);
                } else {
                    p1 = this.transformLL2XYIgnoreMargins(lon, 90.0 + this.phiC_ + 1.0E-5);
                    p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, -90.0 - this.phiC_ + 1.0E-5);
                }
            } else {
                p1 = this.transformLL2XYIgnoreMargins(lon + 180.0, -this.phiC_ + 1.0E-5);
                p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, -this.phiC_ - 1.0E-5);
            }
            if (p1 != null && p2 != null) {
                GraphicUtils.drawLine(g2d, p1, p2);
            }
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }
}

