/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class HammerAzimuthal
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Hammer Azimuthal";
    public static final int PROPERTIES = 0x200040;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 137.0;
    private double dPerspective_ = 2.414213562373095;
    private double radiusFactor_;
    private double cosBorder_;

    public HammerAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public HammerAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 137.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected void prepareScaling() {
        double cosROver4 = Math.cos(0.25 * this.edgeAngleRad_);
        this.dPerspective_ = 4.0 * cosROver4 * cosROver4 - 1.0;
        double cosZ = Math.cos(this.edgeAngleRad_);
        double sinZ = Math.sin(this.edgeAngleRad_);
        this.radiusFactor_ = this.dPerspective_ * sinZ / (this.dPerspective_ + cosZ);
        this.setMaxXYOverRS(this.radiusFactor_);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double maxRadius = Math.max(90.0, this.edgeAngle_);
            double maxRadiusRad = Math.toRadians(maxRadius);
            double cosMaxRad = Math.cos(maxRadiusRad);
            double sinMaxRad = Math.sin(maxRadiusRad);
            double k = this.dPerspective_ / (this.dPerspective_ + cosMaxRad);
            this.rhoBorder_ = k * sinMaxRad * this.rS_;
            this.cosBorder_ = cosMaxRad;
        } else {
            this.rhoBorder_ = this.radiusFactor_ * this.rS_;
            this.cosBorder_ = Math.cos(this.edgeAngleRad_);
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < this.cosBorder_) {
            return -1.0;
        }
        return this.dPerspective_ / (this.dPerspective_ + cosZ);
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double dOverRho = this.dPerspective_ / rhoOverRS;
        double z = rhoOverRS;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = this.dPerspective_ + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

