/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class Gringorten
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Gringorten";
    public static final int PROPERTIES = 73728;
    private static final double COS45 = 0.7071067811865476;
    private static final double SIN45 = 0.7071067811865476;
    private static final double FOUR_OVER_PI = 1.2732395447351628;
    private static final double MAX_X_OVER_RS = 1.4142135623730951;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double top_;
    private double bottom_;
    private double left_;
    private double right_;

    public Gringorten(int width, int height) {
        this(width, height, 0, 0);
    }

    public Gringorten(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 73728, width, height, xmargin, ymargin, 1.4142135623730951, 1.4142135623730951);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        double rSSqrt2 = this.rS_ * 1.4142135623730951;
        this.top_ = (double)this.outCenterY_ - rSSqrt2;
        this.bottom_ = (double)this.outCenterY_ + rSSqrt2;
        this.left_ = (double)this.outCenterX_ - rSSqrt2;
        this.right_ = (double)this.outCenterX_ + rSSqrt2;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.left_, this.top_, this.right_ - this.left_, this.bottom_ - this.top_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            Path2D.Double path = new Path2D.Double();
            path.moveTo(this.outCenterX_, this.top_);
            path.lineTo(this.right_, this.outCenterY_);
            path.lineTo(this.outCenterX_, this.bottom_);
            path.lineTo(this.left_, this.outCenterY_);
            path.closePath();
            g2d.draw(path);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambdaRad = this.lonToLambdaRad(lon);
        if (lambdaRad % 0.7853981633974483 == 0.0) {
            if (lambdaRad < 0.0) {
                lambdaRad += Math.PI * 2;
            }
            int which = (int)(lambdaRad / 0.7853981633974483);
            Path2D.Double path = new Path2D.Double();
            path.moveTo(this.outCenterX_, this.outCenterY_);
            switch (which) {
                case 0: {
                    path.lineTo(this.outCenterX_, this.bottom_);
                    break;
                }
                case 1: {
                    path.lineTo(this.right_, this.bottom_);
                    break;
                }
                case 2: {
                    path.lineTo(this.right_, this.outCenterY_);
                    break;
                }
                case 3: {
                    path.lineTo(this.right_, this.top_);
                    break;
                }
                case 4: {
                    path.lineTo(this.outCenterX_, this.top_);
                    break;
                }
                case 5: {
                    path.lineTo(this.left_, this.top_);
                    break;
                }
                case 6: {
                    path.lineTo(this.left_, this.outCenterY_);
                    break;
                }
                case 7: {
                    path.lineTo(this.left_, this.bottom_);
                    break;
                }
            }
            g2d.draw(path);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad;
        double lambdaRad;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lonP = lon - 45.0;
        for (lambdaRad = this.lonToLambdaRad(lonP); lambdaRad < 0.0; lambdaRad += Math.PI * 2) {
        }
        int hexadecant = lat >= 0.0 ? (int)(lambdaRad / 0.7853981633974483) : (int)(lambdaRad / 0.7853981633974483) + 8;
        double qlambdaRad = lambdaRad % 1.5707963267948966;
        double hlambdaRad = hexadecant % 2 == 0 ? qlambdaRad : 1.5707963267948966 - qlambdaRad;
        double[] result = Gringorten.hexadecantTransformLL2XY(hlambdaRad, phiRad = Math.toRadians(Math.abs(lat)));
        if (result == null) {
            return null;
        }
        double xp = result[0];
        double yp = result[1];
        switch (hexadecant) {
            case 0: {
                break;
            }
            case 1: {
                xp = -xp;
            }
            case 2: {
                double t = xp;
                xp = -yp;
                yp = t;
                break;
            }
            case 3: {
                yp = -yp;
                break;
            }
            case 4: {
                xp = -xp;
                yp = -yp;
                break;
            }
            case 5: {
                xp = -xp;
            }
            case 6: {
                double t = xp;
                xp = yp;
                yp = -t;
                break;
            }
            case 7: {
                xp = -xp;
                break;
            }
            case 8: {
                yp = -2.0 - yp;
                break;
            }
            case 9: {
                xp = -xp;
            }
            case 10: {
                double t = xp;
                xp = -yp;
                yp = t;
                xp = 2.0 - xp;
                break;
            }
            case 11: {
                yp = -yp;
                yp = 2.0 - yp;
                break;
            }
            case 12: {
                xp = -xp;
                yp = -yp;
                yp = 2.0 - yp;
                break;
            }
            case 13: {
                xp = -xp;
            }
            case 14: {
                double t = xp;
                xp = yp;
                yp = -t;
                xp = -2.0 - xp;
                break;
            }
            case 15: {
                xp = -xp;
                yp = -2.0 - yp;
                break;
            }
        }
        double x = 0.7071067811865476 * xp - 0.7071067811865476 * yp;
        double y = 0.7071067811865476 * xp + 0.7071067811865476 * yp;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    private static double[] hexadecantTransformLL2XY(double lambdaRad, double phiRad) {
        double g;
        if (phiRad == 1.5707963267948966) {
            return new double[]{0.0, 0.0};
        }
        double sinPhi = Math.sin(phiRad);
        double r = sinPhi * sinPhi;
        double r2 = r * r;
        double onePlusR2 = 1.0 + r2;
        double oneMinusR2 = 1.0 - r2;
        double sinZ = 1.0 / Math.sqrt(onePlusR2);
        double z = Math.asin(sinZ);
        double v = oneMinusR2 + r * onePlusR2 * z;
        double p2 = (1.0 - sinPhi) / v;
        double p = Math.sqrt(p2);
        double a2 = p2 * onePlusR2;
        double a = Math.sqrt(a2);
        double h = p * oneMinusR2;
        if (lambdaRad == 0.0) {
            return new double[]{0.0, -(h + r * a)};
        }
        double onePlus3R2 = 1.0 + 3.0 * r2;
        double cosPhi = Math.cos(phiRad);
        double secPhi = 1.0 / cosPhi;
        double twoSinPhiCosPhi = 2.0 * sinPhi * cosPhi;
        double fourLambdaOverPi = 1.2732395447351628 * lambdaRad;
        if (lambdaRad > 0.6974335690969341 || phiRad < 0.7853981633974483 && lambdaRad > 0.5497787143782138) {
            double qa = 1.0 + r2;
            double qb = -2.0 * h;
            double qc = h * h - r2 * a2;
            double x45 = 0.5 * (-qb + Math.sqrt(qb * qb - 4.0 * qa * qc)) / qa;
            if (lambdaRad > 0.7853881633974483) {
                return new double[]{x45, x45};
            }
            double xBad = x45;
            double xGood = 0.5 * x45;
            double x = 0.5 * (xGood + xBad);
            for (int niter = 0; niter < 50; ++niter) {
                double drdphi = twoSinPhiCosPhi;
                double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
                double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
                double dpdphi = 0.5 * dp2dphi / p;
                double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
                double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
                double zeta = -2.0 * secPhi * dhdphi;
                double mu = -secPhi * drdphi;
                double nu = -secPhi * dra2dphi;
                double g2 = Math.sqrt(a2 - x * x);
                double zetaPlusMuG = zeta + mu * g2;
                double func = x * zetaPlusMuG + nu * Math.asin(x / a) - fourLambdaOverPi;
                if (func == 0.0) {
                    return new double[]{x, -(h + r * g2)};
                }
                if (func < 0.0) {
                    xGood = x;
                } else {
                    xBad = x;
                }
                x = 0.5 * (xGood + xBad);
                if (!(Math.abs(xBad - xGood) < 1.0E-5)) continue;
                return new double[]{x, -(h + r * g2)};
            }
            return null;
        }
        double x = 1.0E-5;
        for (int iter = 0; iter < 33; ++iter) {
            double x2 = x * x;
            double drdphi = twoSinPhiCosPhi;
            double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
            double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
            double dpdphi = 0.5 * dp2dphi / p;
            double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
            double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
            double zeta = -2.0 * secPhi * dhdphi;
            double mu = -secPhi * drdphi;
            double nu = -secPhi * dra2dphi;
            g = Math.sqrt(a2 - x2);
            double dgdx = -x / g;
            double zetaPlusMuG = zeta + mu * g;
            double func = x * zetaPlusMuG + nu * Math.asin(x / a) - fourLambdaOverPi;
            double dfunc = zetaPlusMuG + mu * x * dgdx + nu / a / Math.sqrt(1.0 - x2 / a2);
            double dx = -func / dfunc;
            x += dx;
            if (Math.abs(dx) < 1.0E-5) break;
        }
        g = Math.sqrt(a2 - x * x);
        double y = -(h + r * g);
        return new double[]{x, y};
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double[] p;
        boolean south;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dyMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        int octant = y > 0.0 ? (x > 0.0 ? (x > y ? 2 : 3) : (Math.abs(x) > y ? 5 : 4)) : (x > 0.0 ? (x > Math.abs(y) ? 1 : 0) : (Math.abs(x) > Math.abs(y) ? 6 : 7));
        double rotate = 45.0 * (double)octant;
        double rotateRad = Math.toRadians(rotate);
        double cosRotate = Math.cos(rotateRad);
        double sinRotate = Math.sin(rotateRad);
        double xp = cosRotate * xOverRS + sinRotate * yOverRS;
        double yp = -sinRotate * xOverRS + cosRotate * yOverRS;
        double xpp = 0.7071067811865476 * xp + 0.7071067811865476 * yp;
        double ypp = -0.7071067811865476 * xp + 0.7071067811865476 * yp;
        boolean bl = south = ypp < -1.0;
        if (south) {
            ypp = -2.0 - ypp;
        }
        if ((p = Gringorten.hexadecantTransformXY2LL(xpp, ypp)) == null) {
            return null;
        }
        double lambda = p[0] + 45.0 + rotate;
        double phi = south ? -p[1] : p[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Gringorten gringorten = this;
        synchronized (gringorten) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = -((double)iy + 0.5) * this.invRS_;
                for (int ix = 0; ix <= iy; ++ix) {
                    double[] p;
                    boolean south;
                    double x = ((double)ix + 0.5) * this.invRS_;
                    double xp = 0.7071067811865476 * x + 0.7071067811865476 * y;
                    double yp = -0.7071067811865476 * x + 0.7071067811865476 * y;
                    boolean bl = south = yp < -1.0;
                    if (south) {
                        yp = -2.0 - yp;
                    }
                    if ((p = Gringorten.hexadecantTransformXY2LL(xp, yp)) == null) continue;
                    if (south) {
                        p[1] = -p[1];
                    }
                    this.setInvPoints(ix, iy, p[0] + 45.0, p[1]);
                }
            }
        }
    }

    private static double[] hexadecantTransformXY2LL(double x, double y) {
        double a2;
        double g2;
        double g;
        double h;
        double p;
        double p2;
        double v;
        double z;
        double sinZ;
        double oneMinusR2;
        double onePlusR2;
        double r2;
        int niter;
        double rGood = 0.0;
        double rBad = 1.0;
        double r = 0.5;
        for (niter = 0; niter < 50; ++niter) {
            r2 = r * r;
            onePlusR2 = 1.0 + r2;
            oneMinusR2 = 1.0 - r2;
            sinZ = 1.0 / Math.sqrt(onePlusR2);
            z = Math.asin(sinZ);
            v = oneMinusR2 + r * onePlusR2 * z;
            p2 = (1.0 - Math.sqrt(r)) / v;
            p = Math.sqrt(p2);
            h = p * oneMinusR2;
            double yphprg = y + h + r * (g = Math.sqrt(g2 = (a2 = p2 * onePlusR2) - x * x));
            if (yphprg == 0.0) break;
            if (yphprg > 0.0) {
                rGood = r;
            } else {
                rBad = r;
            }
            r = 0.5 * (rGood + rBad);
            if (Math.abs(rBad - rGood) < 1.0E-5) break;
        }
        if (niter > 45) {
            return null;
        }
        double sinPhi = Math.sqrt(r);
        double phiRad = Math.asin(sinPhi);
        if (x == y) {
            return new double[]{45.0, Math.toDegrees(phiRad)};
        }
        r2 = r * r;
        onePlusR2 = 1.0 + r2;
        oneMinusR2 = 1.0 - r2;
        sinZ = 1.0 / Math.sqrt(onePlusR2);
        z = Math.asin(sinZ);
        v = oneMinusR2 + r * onePlusR2 * z;
        p2 = (1.0 - Math.sqrt(r)) / v;
        p = Math.sqrt(p2);
        a2 = p2 * onePlusR2;
        double a = Math.sqrt(a2);
        h = p * oneMinusR2;
        g2 = a2 - x * x;
        g = Math.sqrt(g2);
        double cosPhi = Math.cos(phiRad);
        double secPhi = 1.0 / cosPhi;
        double twoSinPhiCosPhi = 2.0 * sinPhi * cosPhi;
        double onePlus3R2 = 1.0 + 3.0 * r2;
        double drdphi = twoSinPhiCosPhi;
        double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
        double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
        double dpdphi = 0.5 * dp2dphi / p;
        double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
        double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
        double zeta = -2.0 * secPhi * dhdphi;
        double mu = -secPhi * drdphi;
        double nu = -secPhi * dra2dphi;
        double zetaPlusMuG = zeta + mu * g;
        double lambdaRad = 0.7853981633974483 * (x * zetaPlusMuG + nu * Math.asin(x / a));
        return new double[]{Math.toDegrees(lambdaRad), Math.toDegrees(phiRad)};
    }

    private void setInvPoints(int ix, int iy, double dlambda, double phi) {
        int[] col = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] row = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        col[0] = this.outCenterX_ + ix;
        col[1] = this.outCenterX_ + iy;
        col[2] = col[1];
        col[3] = col[0];
        col[4] = this.outCenterX_ - ix - 1;
        col[5] = this.outCenterX_ - iy - 1;
        col[6] = col[5];
        col[7] = col[4];
        row[0] = this.outCenterY_ + iy;
        row[1] = this.outCenterY_ + ix;
        row[2] = this.outCenterY_ - ix - 1;
        row[3] = this.outCenterY_ - iy - 1;
        row[4] = row[3];
        row[5] = row[2];
        row[6] = row[1];
        row[7] = row[0];
        for (int i = 0; i < 8; ++i) {
            double lambda = i % 2 == 0 ? this.lambdaC_ + (double)(i * 45) + dlambda : this.lambdaC_ + (double)i * 45.0 + 45.0 - dlambda;
            this.setInverseArrayLocation(col[i], row[i], lambda, phi);
        }
    }
}

