/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.EllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class GottEqualArea
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Gott Equal-Area";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = 1.4142135623730951;
    private static final double MAX_Y_OVER_RS = 0.8723580249548598;
    private static final double AXES_RATIO = 0.6168502750680848;

    public GottEqualArea(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, 1.4142135623730951, 0.8723580249548598);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double halfLambdaRad = 0.5 * this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double sinPhiP = cosPhi * Math.sin(halfLambdaRad);
        double phiPRad = Math.asin(sinPhiP);
        double sin2LambdaP = sinPhi / Math.cos(phiPRad);
        double lambdaPRad = 0.5 * Math.asin(sin2LambdaP);
        double piSinPhiP = Math.PI * sinPhiP;
        double thetaRad = phiPRad * 1.5707963267948966 * 0.5;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhiP;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = 1.4142135623730951 * Math.sin(thetaRad);
        double y = 1.1107207345395915 * lambdaPRad * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double sinTheta = x * this.invRS_ * 0.7071067811865476;
        double thetaRad = Math.asin(sinTheta);
        double lambdaPRad = y * this.invRS_ * 2.0 * 1.4142135623730951 * 0.3183098861837907 / Math.cos(thetaRad);
        double sinPhiP = (2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907;
        double phiPRad = Math.asin(sinPhiP);
        double phiRad = Math.asin(Math.sin(2.0 * lambdaPRad) * Math.cos(phiPRad));
        double lambdaRad = 2.0 * Math.asin(sinPhiP / Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI || Double.isNaN(lambdaRad)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GottEqualArea gottEqualArea = this;
        synchronized (gottEqualArea) {
            double rho2 = this.dyMax_ * this.dyMax_;
            block3: for (int ix = 0; ix < this.dxMax_; ++ix) {
                double y;
                double x = (double)ix + 0.5;
                double sinTheta = x * this.invRS_ * 0.7071067811865476;
                double thetaRad = Math.asin(sinTheta);
                double twoThetaRad = 2.0 * thetaRad;
                double yFactor = this.invRS_ * 1.4142135623730951 * 2.0 * 0.3183098861837907 / Math.cos(thetaRad);
                double x2ratio2 = x * x * 0.6168502750680848 * 0.6168502750680848;
                for (int iy = 0; iy < this.dyMax_ && !(x2ratio2 + (y = (double)iy + 0.5) * y > rho2); ++iy) {
                    double lambdaRad;
                    double lambdaPRad = y * yFactor;
                    double sinPhiP = (twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907;
                    double phiPRad = Math.asin(sinPhiP);
                    double phiRad = Math.asin(Math.sin(2.0 * lambdaPRad) * Math.cos(phiPRad));
                    if (Math.abs(phiRad) > 1.5707963267948966 || Math.abs(lambdaRad = 2.0 * Math.asin(sinPhiP / Math.cos(phiRad))) > Math.PI) continue block3;
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

