/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.GeometryUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class GnomonicIcosahedron
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Gnomonic Icosahedron";
    public static final int PROPERTIES = 0x8000000;
    private static final double CLAT_N = 52.6226318593503;
    private static final double CLAT_T = 10.8123169635717;
    private static final double[][] FACE_LL = new double[][]{{-144.0, 52.6226318593503}, {-144.0, 10.8123169635717}, {-108.0, -10.8123169635717}, {-108.0, -52.6226318593503}, {-72.0, 52.6226318593503}, {-72.0, 10.8123169635717}, {-36.0, -10.8123169635717}, {-36.0, -52.6226318593503}, {0.0, 52.6226318593503}, {0.0, 10.8123169635717}, {36.0, -10.8123169635717}, {36.0, -52.6226318593503}, {72.0, 52.6226318593503}, {72.0, 10.8123169635717}, {108.0, -10.8123169635717}, {108.0, -52.6226318593503}, {144.0, 52.6226318593503}, {144.0, 10.8123169635717}, {180.0, -10.8123169635717}, {180.0, -52.6226318593503}};
    private static final double FACE_H = 1.14589803375032;
    private static final double FACE_W = 1.3231690765;
    private static final double MAX_X_OVER_RS = 3.6387149603749998;
    private static final double MAX_Y_OVER_RS = 1.71884705062548;
    private double faceHRS_;
    private double faceWRS_;
    private double faceHRSOver3_;
    private double faceWRSOver2_;
    private double[][] faceLLRad_ = new double[20][2];
    private double[][] faceXY_ = new double[20][2];
    private double[][][] faceVertices_ = new double[20][3][2];
    private double[] cosPhiC_ = new double[20];
    private double[] sinPhiC_ = new double[20];
    private double[][] faceXYRS_ = new double[20][2];

    public GnomonicIcosahedron(int width, int height) {
        this(width, height, 0, 0);
    }

    public GnomonicIcosahedron(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x8000000, width, height, xmargin, ymargin, 3.6387149603749998, 1.71884705062548);
        int i;
        this.finishConstruction();
        for (i = 0; i < 20; ++i) {
            this.faceLLRad_[i][0] = Math.toRadians(FACE_LL[i][0]);
            this.faceLLRad_[i][1] = Math.toRadians(FACE_LL[i][1]);
            this.cosPhiC_[i] = Math.cos(this.faceLLRad_[i][1]);
            this.sinPhiC_[i] = Math.sin(this.faceLLRad_[i][1]);
        }
        for (i = 0; i < 20; i += 4) {
            int fgroup = i / 4;
            this.faceXY_[i][0] = ((double)fgroup - 2.25) * 1.3231690765;
            this.faceXY_[i][1] = 0.9549150281252666;
            this.faceXY_[i + 1][0] = this.faceXY_[i][0];
            this.faceXY_[i + 1][1] = 0.19098300562505333;
            this.faceXY_[i + 2][0] = ((double)fgroup - 1.75) * 1.3231690765;
            this.faceXY_[i + 2][1] = -0.19098300562505333;
            this.faceXY_[i + 3][0] = this.faceXY_[i + 2][0];
            this.faceXY_[i + 3][1] = -0.9549150281252666;
        }
        for (i = 0; i < 20; i += 2) {
            this.faceVertices_[i][0][0] = this.faceXY_[i][0];
            this.faceVertices_[i][0][1] = this.faceXY_[i][1] + 0.7639320225002133;
            this.faceVertices_[i][1][0] = this.faceXY_[i][0] + 0.66158453825;
            this.faceVertices_[i][1][1] = this.faceXY_[i][1] - 0.38196601125010665;
            this.faceVertices_[i][2][0] = this.faceXY_[i][0] - 0.66158453825;
            this.faceVertices_[i][2][1] = this.faceXY_[i][1] - 0.38196601125010665;
            this.faceVertices_[i + 1][0][0] = this.faceXY_[i + 1][0];
            this.faceVertices_[i + 1][0][1] = this.faceXY_[i + 1][1] - 0.7639320225002133;
            this.faceVertices_[i + 1][1][0] = this.faceXY_[i + 1][0] - 0.66158453825;
            this.faceVertices_[i + 1][1][1] = this.faceXY_[i + 1][1] + 0.38196601125010665;
            this.faceVertices_[i + 1][2][0] = this.faceXY_[i + 1][0] + 0.66158453825;
            this.faceVertices_[i + 1][2][1] = this.faceXY_[i + 1][1] + 0.38196601125010665;
        }
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final void finishScaling() {
        this.faceHRS_ = 1.14589803375032 * this.rS_;
        this.faceWRS_ = 1.3231690765 * this.rS_;
        this.faceHRSOver3_ = this.faceHRS_ / 3.0;
        this.faceWRSOver2_ = 0.5 * this.faceWRS_;
        for (int i = 0; i < 20; ++i) {
            this.faceXYRS_[i][0] = this.faceXY_[i][0] * this.rS_;
            this.faceXYRS_[i][1] = this.faceXY_[i][1] * this.rS_;
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad2;
        int ii;
        double cosZ2;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double xlon = MapUtils.normalizeMP180(lon);
        if (xlon == 180.0) {
            xlon -= 1.0E-10;
        }
        double xlambdaRad = Math.toRadians(xlon);
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double cosPhi = Math.cos(phiRad);
        int face = -1;
        double lambdaRad = Double.NaN;
        double cosZ = Double.NaN;
        for (int i = 0; i < 17; i += 2) {
            if (!(xlon < FACE_LL[i + 3][0])) continue;
            double lambdaRad1 = xlambdaRad - this.faceLLRad_[i][0];
            double lambdaRad22 = xlambdaRad - this.faceLLRad_[i + 1][0];
            double lambdaRad3 = xlambdaRad - this.faceLLRad_[i + 2][0];
            double lambdaRad4 = xlambdaRad - this.faceLLRad_[i + 3][0];
            double cosZ1 = this.sinPhiC_[i] * sinPhi + this.cosPhiC_[i] * cosPhi * Math.cos(lambdaRad1);
            double cosZ22 = this.sinPhiC_[i + 1] * sinPhi + this.cosPhiC_[i + 1] * cosPhi * Math.cos(lambdaRad22);
            double cosZ3 = this.sinPhiC_[i + 2] * sinPhi + this.cosPhiC_[i + 2] * cosPhi * Math.cos(lambdaRad3);
            double cosZ4 = this.sinPhiC_[i + 3] * sinPhi + this.cosPhiC_[i + 3] * cosPhi * Math.cos(lambdaRad4);
            if (cosZ1 >= cosZ22 && cosZ1 >= cosZ3 && cosZ1 >= cosZ4) {
                face = i;
                lambdaRad = lambdaRad1;
                cosZ = cosZ1;
                break;
            }
            if (cosZ22 >= cosZ3 && cosZ22 >= cosZ4) {
                face = i + 1;
                lambdaRad = lambdaRad22;
                cosZ = cosZ22;
                break;
            }
            if (cosZ3 >= cosZ4) {
                face = i + 2;
                lambdaRad = lambdaRad3;
                cosZ = cosZ3;
                break;
            }
            face = i + 3;
            lambdaRad = lambdaRad4;
            cosZ = cosZ4;
            break;
        }
        if (face < 0) {
            return null;
        }
        if ((face == 1 || face == 3) && xlon < -144.0 && (cosZ2 = this.sinPhiC_[ii = face == 1 ? 18 : 19] * sinPhi + this.cosPhiC_[ii] * cosPhi * Math.cos(lambdaRad2 = xlambdaRad - this.faceLLRad_[ii][0])) > cosZ) {
            face = ii;
            lambdaRad = lambdaRad2;
            cosZ = cosZ2;
        }
        double x = cosPhi * Math.sin(lambdaRad);
        double y = this.cosPhiC_[face] * sinPhi - this.sinPhiC_[face] * cosPhi * Math.cos(lambdaRad);
        x /= cosZ;
        y /= cosZ;
        x += this.faceXY_[face][0];
        y += this.faceXY_[face][1];
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double dy;
        double dx;
        double[] lambdaPhi;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        if (Math.abs(yOverRS) > 1.71884705062548 || Math.abs(xOverRS) > 3.6387149603749998) {
            return null;
        }
        int face = -1;
        if (yOverRS > 0.57294901687516) {
            if (xOverRS > 2.9771304221249997) {
                return null;
            }
            face = (int)((xOverRS + 3.6387149603749998) / 1.3231690765);
            if ((face *= 4) > 16) {
                return null;
            }
            if (!this.isUnscaledXYInFace(face, xOverRS, yOverRS)) {
                return null;
            }
        } else if (yOverRS < -0.57294901687516) {
            if (xOverRS < -2.9771304221249997) {
                return null;
            }
            face = (int)((xOverRS + 2.9771304221249997) / 1.3231690765);
            face *= 4;
            if ((face += 3) < 3) {
                return null;
            }
            if (!this.isUnscaledXYInFace(face, xOverRS, yOverRS)) {
                return null;
            }
        } else {
            face = (int)((xOverRS + 3.6387149603749998) / 1.3231690765);
            int face1 = (face *= 4) - 2;
            int face2 = face + 1;
            int face3 = face + 2;
            if (face1 > 0 && this.isUnscaledXYInFace(face1, xOverRS, yOverRS)) {
                face = face1;
            } else if (this.isUnscaledXYInFace(face2, xOverRS, yOverRS)) {
                face = face2;
            } else if (this.isUnscaledXYInFace(face3, xOverRS, yOverRS)) {
                face = face3;
            } else {
                return null;
            }
        }
        if ((lambdaPhi = this.getLambdaPhiForScaledXY(face, dx = x - this.faceXYRS_[face][0], dy = y - this.faceXYRS_[face][1])) == null) {
            return null;
        }
        return new PointLL(lambdaPhi[0], lambdaPhi[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GnomonicIcosahedron gnomonicIcosahedron = this;
        synchronized (gnomonicIcosahedron) {
            block3: for (int face = 0; face < 20; ++face) {
                double ytop;
                double ybot;
                if (face % 2 == 0) {
                    ybot = this.faceXYRS_[face][1] - this.faceHRSOver3_;
                    ytop = ybot + this.faceHRS_;
                } else {
                    ybot = this.faceXYRS_[face][1] - 2.0 * this.faceHRSOver3_;
                    ytop = ybot + this.faceHRS_;
                }
                int iypxl = (int)(ybot - 0.5);
                while ((double)iypxl < ytop + 1.0) {
                    double ypxl = (double)iypxl + 0.5;
                    if (!(ypxl < ybot)) {
                        if (ypxl > ytop) continue block3;
                        double dy = ypxl - this.faceXYRS_[face][1];
                        double dxmax = face % 2 == 0 ? this.faceWRSOver2_ * (ytop - ypxl) / this.faceHRS_ : this.faceWRSOver2_ * (ypxl - ybot) / this.faceHRS_;
                        double xleft = this.faceXYRS_[face][0] - dxmax;
                        double xright = this.faceXYRS_[face][0] + dxmax;
                        int ixpxl = (int)(xleft - 0.5);
                        while ((double)ixpxl <= xright + 1.0) {
                            double xpxl = (double)ixpxl + 0.5;
                            if (!(xpxl < xleft)) {
                                if (xpxl > xright) break;
                                double dx = xpxl - this.faceXYRS_[face][0];
                                double[] lambdaPhi = this.getLambdaPhiForScaledXY(face, dx, dy);
                                if (lambdaPhi != null) {
                                    this.setInvPoint(ixpxl, iypxl, lambdaPhi[0], lambdaPhi[1]);
                                }
                            }
                            ++ixpxl;
                        }
                    }
                    ++iypxl;
                }
            }
        }
    }

    private boolean isUnscaledXYInFace(int face, double xOverRS, double yOverRS) {
        if (face < 0 || face > 19) {
            return false;
        }
        boolean isIn = GeometryUtils.isPointInTriangle(xOverRS, yOverRS, this.faceVertices_[face][0][0], this.faceVertices_[face][0][1], this.faceVertices_[face][1][0], this.faceVertices_[face][1][1], this.faceVertices_[face][2][0], this.faceVertices_[face][2][1]);
        return isIn;
    }

    private double[] getLambdaPhiForScaledXY(int face, double dx, double dy) {
        double rho2 = dx * dx + dy * dy;
        double rho = Math.sqrt(rho2);
        double z = Math.atan(rho * this.invRS_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double lambdaRad = Math.atan2(dx * sinZ, rho * this.cosPhiC_[face] * cosZ - dy * this.sinPhiC_[face] * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_[face] + dy * sinZ * this.cosPhiC_[face] / rho);
        double lambda = Math.toDegrees(lambdaRad) + FACE_LL[face][0];
        double phi = Math.toDegrees(phiRad);
        return new double[]{lambda, phi};
    }

    protected void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        int i;
        Stroke oldstroke = g2d.getStroke();
        g2d.setStroke(ProjectionUtils.getSquareMiterStroke(oldstroke));
        Path2D.Double path = new Path2D.Double();
        path.moveTo((double)this.outCenterX_ - 2.75 * this.faceWRS_, (double)this.outCenterY_ - 0.5 * this.faceHRS_);
        for (i = 0; i < 5; ++i) {
            path.lineTo((double)this.outCenterX_ - (2.25 - (double)i) * this.faceWRS_, (double)this.outCenterY_ - 1.5 * this.faceHRS_);
            path.lineTo((double)this.outCenterX_ - (1.75 - (double)i) * this.faceWRS_, (double)this.outCenterY_ - 0.5 * this.faceHRS_);
        }
        path.lineTo((double)this.outCenterX_ + 2.75 * this.faceWRS_, (double)this.outCenterY_ + 0.5 * this.faceHRS_);
        for (i = 0; i < 5; ++i) {
            path.lineTo((double)this.outCenterX_ + (2.25 - (double)i) * this.faceWRS_, (double)this.outCenterY_ + 1.5 * this.faceHRS_);
            path.lineTo((double)this.outCenterX_ + (1.75 - (double)i) * this.faceWRS_, (double)this.outCenterY_ + 0.5 * this.faceHRS_);
        }
        path.closePath();
        g2d.draw(path);
        g2d.setStroke(ProjectionUtils.getSquareMiterStroke(0.33f));
        path.reset();
        path.moveTo((double)this.outCenterX_ - 2.75 * this.faceWRS_, (double)this.outCenterY_ - 0.5 * this.faceHRS_);
        path.lineTo((double)this.outCenterX_ + 2.25 * this.faceWRS_, (double)this.outCenterY_ - 0.5 * this.faceHRS_);
        for (i = 0; i < 4; ++i) {
            path.lineTo((double)this.outCenterX_ + (1.75 - (double)i) * this.faceWRS_, (double)this.outCenterY_ + 0.5 * this.faceHRS_);
            path.lineTo((double)this.outCenterX_ + (1.25 - (double)i) * this.faceWRS_, (double)this.outCenterY_ - 0.5 * this.faceHRS_);
        }
        path.lineTo((double)this.outCenterX_ - 2.25 * this.faceWRS_, (double)this.outCenterY_ + 0.5 * this.faceHRS_);
        path.lineTo((double)this.outCenterX_ + 2.75 * this.faceWRS_, (double)this.outCenterY_ + 0.5 * this.faceHRS_);
        g2d.draw(path);
        g2d.setStroke(oldstroke);
    }
}

