/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class EquidistantConic
extends ConicProjection {
    public static final String PROJECTION_NAME = "Equidistant Conic";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double termN_;
    private double invN_;
    private double termF_;
    private double rho0_;

    public EquidistantConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquidistantConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200010, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        if (this.phi1_ == this.phi2_) {
            this.termN_ = this.phi1_ >= 0.0 ? 1.0 : -1.0;
            this.termF_ = 1.0 / Math.tan(phi1Rad) + phi1Rad;
        } else {
            this.termN_ = (cosPhi1 - cosPhi2) / (phi2Rad - phi1Rad);
            this.termF_ = (phi2Rad * cosPhi1 - phi1Rad * cosPhi2) / (cosPhi1 - cosPhi2);
        }
        this.invN_ = 1.0 / this.termN_;
        this.rho0_ = this.termF_ - this.phiCRad_;
        double dPhi = this.phiHeight_;
        double phiTRad = Math.toRadians(Math.min(90.0, this.phiC_ + 0.5 * dPhi));
        double phiBRad = Math.toRadians(Math.max(-90.0, this.phiC_ - 0.5 * dPhi));
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * Math.toRadians(dPhi);
        double rhoT = this.termF_ - phiTRad;
        double rhoB = this.termF_ - phiBRad;
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT2 = rhoT * Math.sin(theta2);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rho0_ - rhoT * Math.cos(theta1);
        double yT2 = this.rho0_ - rhoT * Math.cos(theta2);
        double yB1 = this.rho0_ - rhoB * Math.cos(theta1);
        double yB2 = this.rho0_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double widthFactor = Math.max(xT2, xB2);
        double heightFactor = Math.max(Math.abs(yT), Math.abs(yB));
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double rho = this.termF_ - phiRad;
        double thetaRad = this.termN_ * lambdaRad;
        double x = rho * Math.sin(thetaRad);
        double y = this.rho0_ - rho * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double rho0_MinusYOverRS = this.rho0_ - yOverRS;
        double rho = Math.sqrt(xOverRS * xOverRS + rho0_MinusYOverRS * rho0_MinusYOverRS);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0_MinusYOverRS) : Math.atan2(xOverRS, rho0_MinusYOverRS);
        double lambdaRad = thetaRad * this.invN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        EquidistantConic equidistantConic = this;
        synchronized (equidistantConic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double rho0_MinusYOverRS = this.rho0_ - yOverRS;
                double rho0_MinusYOverRSSq = rho0_MinusYOverRS * rho0_MinusYOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double theta;
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + rho0_MinusYOverRSSq);
                    if (this.termN_ < 0.0) {
                        rho = -rho;
                    }
                    if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966 || (lambdaRad = (theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0_MinusYOverRS) : Math.atan2(xOverRS, rho0_MinusYOverRS)) * this.invN_) > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

