/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class CompactMiller
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "Compact Miller";
    private static final double K1 = 0.9902;
    private static final double K2 = 0.1604;
    private static final double K3 = -0.03054;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.8850208335653647;

    public CompactMiller(int width, int height) {
        this(width, height, 0, 0);
    }

    public CompactMiller(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.8850208335653647);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = this.lonToLambdaRad(lon);
        double y = phiRad * (0.9902 + phiRad2 * (0.1604 + phiRad2 * -0.03054));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double func = phiRad * (0.9902 + 0.1604 * phiRad2 + -0.03054 * phiRad4) - yOverRS;
            double dfunc = 0.9902 + 0.48119999999999996 * phiRad2 + -0.1527 * phiRad4;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CompactMiller compactMiller = this;
        synchronized (compactMiller) {
            double lastPhiRad = 1.0E-5;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = lastPhiRad;
                for (int iter = 0; iter < 33; ++iter) {
                    double phiRad2 = phiRad * phiRad;
                    double phiRad4 = phiRad2 * phiRad2;
                    double func = phiRad * (0.9902 + 0.1604 * phiRad2 + -0.03054 * phiRad4) - yOverRS;
                    double dfunc = 0.9902 + 0.48119999999999996 * phiRad2 + -0.1527 * phiRad4;
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                if (phiRad > 1.5707963267948966) break;
                lastPhiRad = phiRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

