/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEAOblique
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Cylindrical Equal-Area (Oblique)";
    public static final int PROPERTIES = 10493956;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.0;
    private static final double DEFAULT_H0 = 1.0;
    private double csubx_ = 1.0;
    private double csuby_ = 1.0;
    private double csubxRS_ = 1.0;
    private double csubyRS_ = 1.0;
    private final ProjDoubleParameter h0Param_;
    private final ProjDoubleParameter rotateParam_;
    private final LonLatRotator rotMatrices_ = new LonLatRotator(-90.0, 0.0, 90.0);
    private double xAxisRotation_;

    public CEAOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 10493956, width, height, xmargin, ymargin, Math.PI, 1.0);
        this.h0Param_ = new ProjDoubleParameter("Scaling term h\u2080", "Scaling h\u2080", "(0.5\u2264h\u2080\u22641)", 1.0, 0.5, 1.0, true, true);
        this.rotateParam_ = new ProjDoubleParameter("Third (plagal) rotation", "Third rotation", "\u00b0 ", this.xAxisRotation_, -360.0, 360.0, true, true);
        this.addParameter(this.h0Param_);
        this.addParameter(this.rotateParam_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        double rotate;
        super.setCenter(lon, lat);
        double d = rotate = this.rotateParam_ == null ? 0.0 : this.rotateParam_.getValue();
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat, rotate);
        }
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.h0Param_) {
            this.setScaling(this.h0Param_.getValue());
            this.setXAxisRotation(this.rotateParam_.getValue());
        } else if (p == this.h0Param_) {
            this.setScaling(this.h0Param_.getValue());
        } else if (p == this.rotateParam_) {
            this.setXAxisRotation(this.rotateParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setScaling(double h0) {
        this.csubx_ = h0;
        this.csuby_ = 1.0 / h0;
        this.csubxRS_ = 1.0;
        this.csubyRS_ = 1.0;
        this.autoscale();
    }

    private void setXAxisRotation(double angle) {
        this.xAxisRotation_ = angle;
        this.rotMatrices_.setAngles(this.lambdaC_, this.phiC_, this.xAxisRotation_);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double widthFactor = this.csubx_ * Math.PI;
        double heightFactor = this.csuby_ * 1.0;
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        this.csubxRS_ = this.csubx_ * this.rS_;
        this.csubyRS_ = this.csuby_ * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double lonP = llP[0];
        double latP = llP[1];
        double x = Math.toRadians(lonP);
        double y = Math.sin(Math.toRadians(latP));
        x *= this.csubxRS_;
        y *= this.csubyRS_;
        x = (double)this.outCenterX_ + x;
        y = (double)this.outCenterY_ - y;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverCyRS = y / this.csubyRS_;
        double phiPRad = Math.asin(yOverCyRS);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double xOverCxRS = x / this.csubxRS_;
        double lambdaPRad = xOverCxRS;
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double phiP = Math.toDegrees(phiPRad);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CEAOblique cEAOblique = this;
        synchronized (cEAOblique) {
            double y;
            double yOverCyRS;
            double phiPRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiPRad = Math.asin(yOverCyRS = (y = (double)iy + 0.5) / this.csubyRS_)) > 1.5707963267948966); ++iy) {
                double x;
                double xOverCxRS;
                double lambdaPRad;
                double phiP = Math.toDegrees(phiPRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaPRad = (xOverCxRS = (x = (double)ix + 0.5) / this.csubxRS_)) > Math.PI); ++ix) {
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double[] llTR = this.rotMatrices_.inverse(lambdaP, phiP);
                    double[] llBR = this.rotMatrices_.inverse(lambdaP, -phiP);
                    double[] llBL = this.rotMatrices_.inverse(-lambdaP, -phiP);
                    double[] llTL = this.rotMatrices_.inverse(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }

    private void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }
}

