/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;

public class BreusingGeometric2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Breusing Geometric (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double RADIUS_FACTOR = 2.0 * Math.sqrt(0.7071067811865476);

    public BreusingGeometric2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public BreusingGeometric2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, RADIUS_FACTOR);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        double z = Math.acos(cosZ);
        double halfZ = 0.5 * z;
        double sinZ = Math.sin(z);
        double tanHalfZ = sinZ / (1.0 + cosZ);
        double rho = 2.0 * Math.sqrt(tanHalfZ * Math.sin(halfZ));
        return rho / sinZ;
    }

    @Override
    protected double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double z = 0.7853981633974483;
        for (int iter = 0; iter < 33; ++iter) {
            double halfZ = 0.5 * z;
            double cosHalfZ = Math.cos(halfZ);
            double sqrtCosHalfZ = Math.sqrt(cosHalfZ);
            double sinHalfZ = Math.sin(halfZ);
            double tanHalfZ = Math.tan(halfZ);
            double func = 2.0 * (sinHalfZ / sqrtCosHalfZ) - rhoOverRS;
            double dfunc = sqrtCosHalfZ * (1.0 + 0.5 * tanHalfZ * tanHalfZ);
            double dz = -func / dfunc;
            z += dz;
            if (!(Math.abs(dz) < 1.0E-5)) continue;
            return z;
        }
        return Double.NaN;
    }
}

