/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class BreusingGeometric
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Breusing Geometric";
    public static final int PROPERTIES = 0x200040;
    private static final double MAX_CLIP_ANGLE = 150.0;
    private static final double MAX_CLIP_ANGLE_RAD = Math.toRadians(150.0);
    private static final double DEFAULT_CLIP_ANGLE = 90.0;

    public BreusingGeometric(int width, int height) {
        this(width, height, 0, 0);
    }

    public BreusingGeometric(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 150.0, false);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double z = this.edgeAngleRad_;
        double halfZ = 0.5 * z;
        double sinHalfZ = Math.sin(halfZ);
        double tanHalfZ = Math.tan(halfZ);
        double rhoEdgeOverR = 2.0 * Math.sqrt(tanHalfZ * sinHalfZ);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double halfZ = 0.5 * Math.toRadians(150.0);
            double sinHalfZ = Math.sin(halfZ);
            double tanHalfZ = Math.tan(halfZ);
            double rhoBOverR = 2.0 * Math.sqrt(tanHalfZ * sinHalfZ);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double halfZ = 0.5 * z;
        double sinZ = Math.sin(z);
        double tanHalfZ = sinZ / (1.0 + cosZ);
        double rho = 2.0 * Math.sqrt(tanHalfZ * Math.sin(halfZ));
        return rho / sinZ;
    }

    @Override
    protected double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        boolean found = false;
        double z = this.fillCorners_ ? rho * MAX_CLIP_ANGLE_RAD / this.rhoBorder_ : rho * this.edgeAngleRad_ / this.rhoBorder_;
        for (int iter = 0; iter < 33; ++iter) {
            double halfZ = 0.5 * z;
            double cosHalfZ = Math.cos(halfZ);
            double sqrtCosHalfZ = Math.sqrt(cosHalfZ);
            double sinHalfZ = Math.sin(halfZ);
            double tanHalfZ = Math.tan(halfZ);
            double func = 2.0 * (sinHalfZ / sqrtCosHalfZ) - rhoOverRS;
            double dfunc = sqrtCosHalfZ * (1.0 + 0.5 * tanHalfZ * tanHalfZ);
            double dz = -func / dfunc;
            z += dz;
            if (!(Math.abs(dz) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return Double.NaN;
        }
        return z;
    }
}

