/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bonne
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bonne";
    public static final int PROPERTIES = 8704;
    private static final double DEFAULT_PHI1 = 50.0;
    private static final double MAX_X_OVER_RS = Math.PI * 2;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double phi1_ = 50.0;
    private double phi1Rad_;
    private double cotPhi1_;
    private double yshift_;
    private double lobeTipLat_;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 50.0, -90.0, 90.0, true, true);

    public Bonne(int width, int height) {
        this(width, height, 0, 0);
    }

    public Bonne(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8704, width, height, xmargin, ymargin, Math.PI * 2, Math.PI);
        this.addParameter(this.phi1Param_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.phi1Param_) {
            this.setStandardParallel(this.phi1Param_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        this.phi1_ = lat;
        if (this.phi1_ == 0.0) {
            this.phi1_ = 1.0E-6;
        }
        this.phi1Rad_ = Math.toRadians(this.phi1_);
        this.cotPhi1_ = 1.0 / Math.tan(this.phi1Rad_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double yy;
        double latX = this.latitudeOfMaxX();
        double phiRad = Math.toRadians(latX);
        double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        double betaRad = Math.PI * Math.cos(phiRad) / alphaRad;
        double widthFactor = alphaRad * Math.sin(betaRad);
        double phiRad2 = this.phi1_ > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        double alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y1 = this.cotPhi1_ - alphaRad2;
        phiRad2 = this.phi1_ > 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y2 = this.cotPhi1_ - alphaRad2;
        if (Math.abs(this.phi1_) > 11.5232593818) {
            this.lobeTipLat_ = this.latitudeOfLobeMaxY();
            if (Double.isNaN(this.lobeTipLat_)) {
                this.lobeTipLat_ = 0.0;
                yy = y1;
            } else {
                phiRad2 = Math.toRadians(this.lobeTipLat_);
                alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
                double betaRad2 = Math.PI * Math.cos(phiRad2) / alphaRad2;
                yy = this.cotPhi1_ - alphaRad2 * Math.cos(betaRad2);
            }
        } else {
            this.lobeTipLat_ = 0.0;
            yy = y1;
        }
        if (Math.abs(y1) > Math.abs(yy)) {
            yy = y1;
        }
        this.yshift_ = -0.5 * (yy + y2);
        double heightFactor = 0.5 * Math.abs(yy - y2);
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.yshift_ * this.rS_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double betaRad = lambdaRad * Math.cos(phiRad) / alphaRad;
        double x = alphaRad * Math.sin(betaRad);
        double y = this.yshift_ + this.cotPhi1_ - alphaRad * Math.cos(betaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double y1;
        double xOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        double alphaRad = pmFac * Math.hypot(xOverRS = x * this.invRS_, y1 = this.cotPhi1_ - (yOverRS = y * this.invRS_ - this.yshift_));
        double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Bonne bonne = this;
        synchronized (bonne) {
            double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                double y1 = this.cotPhi1_ - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double alphaRad = pmFac * Math.hypot(xOverRS, y1);
                    double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
                    if (Math.abs(phiRad) > 1.5707963267948966) continue;
                    double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
                    double lambdaRad = betaRad * alphaRad / Math.cos(phiRad);
                    if (lambdaRad > Math.PI) {
                        if (!(Math.abs(this.phi1_) < 11.5232593818)) continue;
                        continue block3;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeMeridianBezier(this.lambdaC_ + 179.99999);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(this.lambdaC_ - 179.99999)) != null) {
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ - 179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
        Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeMeridianBezier(lon);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        double lat = -90.0;
        while (lat < 90.0) {
            double absLat;
            dot = this.transformLL2XY(lon, lat);
            if (dot != null) {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
            }
            if ((absLat = Math.abs(lat)) >= 89.0) {
                lat += 0.1;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.5;
        }
        dot = this.transformLL2XY(lon, 90.0);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }

    private double latitudeOfMaxX() {
        if (this.phi1_ == 0.0) {
            return 0.0;
        }
        double phiRad = -Math.toRadians(0.5 * this.phi1_);
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double betaRad = Math.PI * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-Math.PI * sinPhi + betaRad) / alphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double func = -sinBeta + alphaRad * dsinBeta;
            double dfunc = alphaRad * dcosBeta * dbetaRad - cosBeta * Math.PI * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }

    private double latitudeOfLobeMaxY() {
        if (Math.abs(this.phi1_) <= 11.5232593818) {
            return Double.NaN;
        }
        double dalphaRad = -1.0;
        double phiRad = Math.toRadians(45.0);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double alphaRad2 = alphaRad * alphaRad;
            double betaRad = Math.PI * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = -Math.PI * sinPhi / alphaRad + betaRad / alphaRad;
            double d2betaRad = -Math.PI * cosPhi / alphaRad + Math.PI * sinPhi * -1.0 / alphaRad2 + dbetaRad / alphaRad + betaRad / alphaRad2;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double d2cosBeta = -(dsinBeta * dbetaRad + sinBeta * d2betaRad);
            double func = cosBeta - alphaRad * dcosBeta;
            double dfunc = dcosBeta - -1.0 * dcosBeta - alphaRad * d2cosBeta;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }
}

