/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerghausStar
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Berghaus Star";
    public static final int PROPERTIES = 0x1020002;
    private static final double JOIN_LAT = 0.0;
    private static final double JOIN_LAT_RAD = 0.0;
    private static final int NUM_LOBES = 5;
    private static final double LOBE_WIDTH = 72.0;
    private static final double HALF_LOBE_WIDTH = 36.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(72.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double COS_HALF_LOBE_WIDTH = Math.cos(HALF_LOBE_WIDTH_RAD);
    private static final double SIN_HALF_LOBE_WIDTH = Math.sin(HALF_LOBE_WIDTH_RAD);
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double MAX_X_OVER_RS = Math.sin(1.5 * LOBE_WIDTH_RAD) * Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966 * (1.0 + Math.cos(HALF_LOBE_WIDTH_RAD));
    private static final double Y_SHIFT = MAX_Y_OVER_RS - Math.PI;
    private static final double REFERENCE_LON = -16.0;
    private double outCenterYActual_;

    public BerghausStar(int width, int height) {
        this(width, height, 0, 0);
    }

    public BerghausStar(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1020002, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        super.setCenter(-16.0, 90.0);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final void finishScaling() {
        this.outCenterYActual_ = (double)this.outCenterY_ - Y_SHIFT * this.rS_;
        LOGGER.trace("OCY {}, shift {}, OCYA {}", this.outCenterY_, Y_SHIFT, this.outCenterYActual_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, this.outCenterYActual_);
        }
        double phiRad = Math.toRadians(lat);
        if (lat >= 0.0) {
            double sinPhi;
            double lambdaRad = this.lonToLambdaRad(lon);
            double cosPhi = Math.cos(phiRad);
            double cosZ = sinPhi = Math.sin(phiRad);
            double z = Math.acos(cosZ);
            double k = z / Math.sin(z);
            double rho = k * cosPhi;
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double lambda = MapUtils.normalize360(this.lonToLambda(lon));
            int lobe = (int)(lambda / 72.0);
            double rho = 1.5707963267948966 - phiRad;
            double xlambda = lambda - 72.0 * (double)lobe - 36.0;
            double absXlambda = Math.abs(xlambda);
            double xlambdaRad = Math.toRadians(absXlambda);
            double cosLambda = Math.cos(xlambdaRad);
            double sinLambda = Math.sin(xlambdaRad);
            double dBE = 1.5707963267948966 * sinLambda;
            double dDE = 1.5707963267948966 * Math.sqrt(5.0 - 4.0 * cosLambda);
            double sinLambdaPP = dBE / dDE;
            double sinTheta = Math.PI / rho * sinLambdaPP;
            double lambdaPPRad = Math.asin(sinLambdaPP);
            double thetaRad = Math.PI - Math.asin(sinTheta);
            double lambdaPRad = Math.PI - Math.abs(lambdaPPRad) - Math.abs(thetaRad);
            if (xlambda < absXlambda) {
                lambdaPRad = -lambdaPRad;
            }
            double sinLambdaP = Math.sin(lambdaPRad);
            double cosLambdaP = Math.cos(lambdaPRad);
            double xx = rho * sinLambdaP;
            double yy = -rho * cosLambdaP;
            double xxx = COS_HALF_LOBE_WIDTH * xx - SIN_HALF_LOBE_WIDTH * yy;
            double yyy = SIN_HALF_LOBE_WIDTH * xx + COS_HALF_LOBE_WIDTH * yy;
            for (int i = 1; i <= lobe; ++i) {
                x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                xxx = x;
                yyy = y;
            }
            x = xxx;
            y = yyy;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = this.outCenterYActual_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = this.outCenterYActual_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        double xOverRS = absx * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + (yOverRS = y * this.invRS_) * yOverRS);
        if (rho > Math.PI) {
            return null;
        }
        double phiRad = 1.5707963267948966 - rho;
        if (phiRad >= 0.0) {
            lambdaRad = Math.atan2(absx, -y);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
            double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double lambdaPPRad = Math.atan2(Math.abs(xrot), Math.PI - Math.abs(yrot));
            if (Double.isNaN(lambdaPPRad)) {
                return null;
            }
            double sinLambdaPP = Math.sin(lambdaPPRad);
            double sinThetaP = Math.abs(2.0 * sinLambdaPP);
            double thetaPRad = Math.PI - Math.asin(sinThetaP);
            if (Double.isNaN(thetaPRad)) {
                return null;
            }
            lambdaRad = Math.PI - lambdaPPRad - thetaPRad;
            if (lambdaRad > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            if (xrot < 0.0) {
                lambdaRad = -lambdaRad;
            }
            lambdaRad -= rotateRad;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BerghausStar berghausStar = this;
        synchronized (berghausStar) {
            for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y2OverR2S2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverR2S2);
                    if (rho > Math.PI) continue;
                    double phiRad = 1.5707963267948966 - rho;
                    if (phiRad >= 0.0) {
                        lambdaRad = Math.atan2(xOverRS, -yOverRS);
                    } else {
                        double sinLambdaPP;
                        double sinThetaP;
                        double thetaPRad;
                        double zetaRad;
                        for (zetaRad = Math.atan2(xOverRS, -yOverRS); zetaRad < 0.0; zetaRad += Math.PI * 2) {
                        }
                        int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
                        double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double lambdaPPRad = Math.atan2(Math.abs(xrot), Math.PI - Math.abs(yrot));
                        if (Double.isNaN(lambdaPPRad) || Double.isNaN(thetaPRad = Math.PI - Math.asin(sinThetaP = Math.abs(2.0 * (sinLambdaPP = Math.sin(lambdaPPRad))))) || (lambdaRad = Math.PI - lambdaPPRad - thetaPRad) > HALF_LOBE_WIDTH_RAD) continue;
                        if (xrot < 0.0) {
                            lambdaRad = -lambdaRad;
                        }
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 5; ++i) {
            double lon1 = this.lambdaC_ + (double)i * 72.0 + 1.0E-5;
            double lon2 = this.lambdaC_ + (double)i * 72.0 + 36.0;
            double lon3 = this.lambdaC_ + (double)i * 72.0 + 72.0 - 1.0E-5;
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, 0.0);
            Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, -90.0);
            Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, 0.0);
            GraphicUtils.drawLine(g2d, dot1, dot2);
            GraphicUtils.drawLine(g2d, dot2, dot3);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat >= 0.0) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 60.0, lat);
            if (dot == null) {
                return;
            }
            double dx = (double)this.outCenterX_ - dot.x;
            double dy = this.outCenterYActual_ - dot.y;
            double r = Math.sqrt(dx * dx + dy * dy);
            g2d.translate((double)this.outCenterX_, this.outCenterYActual_);
            ProjectionUtils.drawEllipse(g2d, 0.0, 0.0, r, r);
            g2d.translate((double)(-this.outCenterX_), -this.outCenterYActual_);
        } else {
            for (int i = 0; i < 5; ++i) {
                double lon1 = this.lambdaC_ + (double)i * 72.0 + 1.0E-5;
                double lon2 = this.lambdaC_ + (double)i * 72.0 + 36.0;
                double lon3 = this.lambdaC_ + (double)i * 72.0 + 72.0 - 1.0E-5;
                Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
                Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
                Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
                GraphicUtils.drawCircularArc(g2d, dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        for (int i = 0; i < 5; ++i) {
            double lobeCenter = MapUtils.normalizeMP180(this.lambdaC_ + (double)i * 72.0 + 36.0);
            double cdiff = Math.abs(MapUtils.normalizeMP180(lon - lobeCenter));
            if (cdiff > 36.0) continue;
            Point2D.Double dot90S = this.transformLL2XYIgnoreMargins(lon, -90.0);
            if (Math.abs(cdiff) < 1.0E-5) {
                GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterYActual_, dot90S.x, dot90S.y);
                return;
            }
            Point2D.Double dotEq = this.transformLL2XYIgnoreMargins(lon, 0.0);
            GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterYActual_, dotEq.x, dotEq.y);
            if (cdiff > 35.99999) {
                return;
            }
            GraphicUtils.drawLine(g2d, dotEq, dot90S);
        }
    }
}

