/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BartholomewTetrahedral
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bartholomew Tetrahedral";
    public static final int PROPERTIES = 0x1020002;
    private static final double JOIN_LAT = 23.5;
    private static final double JOIN_LAT_RAD = Math.toRadians(23.5);
    private static final double JOIN_COLAT_RAD = 1.5707963267948966 - JOIN_LAT_RAD;
    private static final double COS_JOIN = Math.cos(JOIN_LAT_RAD);
    private static final double SEC_JOIN = 1.0 / COS_JOIN;
    private static final int NUM_LOBES = 3;
    private static final double LOBE_WIDTH = 120.0;
    private static final double HALF_LOBE_WIDTH = 60.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(120.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double PAR_SCALING = JOIN_COLAT_RAD * SEC_JOIN;
    private static final double INV_PAR_SCALING = COS_JOIN / JOIN_COLAT_RAD;
    private static final double COS_HALF_LOBE_WIDTH = Math.cos(HALF_LOBE_WIDTH_RAD);
    private static final double SIN_HALF_LOBE_WIDTH = Math.sin(HALF_LOBE_WIDTH_RAD);
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double MAX_X_OVER_RS = SIN_HALF_LOBE_WIDTH * Math.PI;
    private static final double MAX_Y_OVER_RS = 0.5 * (Math.PI + SIN_HALF_LOBE_WIDTH * (1.5707963267948966 - Math.toRadians(-44.468)));
    private static final double Y_SHIFT = MAX_Y_OVER_RS - Math.PI;
    private static final double REFERENCE_LON = -30.0;
    private double outCenterYActual_;

    public BartholomewTetrahedral(int width, int height) {
        this(width, height, 0, 0);
    }

    public BartholomewTetrahedral(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1020002, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        super.setCenter(-30.0, 90.0);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final void finishScaling() {
        this.outCenterYActual_ = (double)this.outCenterY_ - Y_SHIFT * this.rS_;
        LOGGER.trace("OCY {}, shift {}, OCYA {}", this.outCenterY_, Y_SHIFT, this.outCenterYActual_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, this.outCenterYActual_);
        }
        double phiRad = Math.toRadians(lat);
        if (lat >= 23.5) {
            double sinPhi;
            double lambdaRad = this.lonToLambdaRad(lon);
            double cosPhi = Math.cos(phiRad);
            double cosZ = sinPhi = Math.sin(phiRad);
            double z = Math.acos(cosZ);
            double k = z / Math.sin(z);
            double rho = k * cosPhi;
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double alphaRad;
            double lambda;
            for (lambda = this.lonToLambda(lon); lambda < 0.0; lambda += 360.0) {
            }
            int lobe = (int)(lambda / 120.0);
            double rho = alphaRad = 1.5707963267948966 - phiRad;
            double rotateRad = -(120.0 * (double)lobe + 60.0);
            double xlambdaRad = Math.toRadians(lambda + rotateRad);
            double betaRad = lat < -89.99999 ? 0.0 : PAR_SCALING * xlambdaRad * Math.cos(phiRad) / alphaRad;
            double xx = rho * Math.sin(betaRad);
            double yy = -rho * Math.cos(betaRad);
            double xxx = COS_HALF_LOBE_WIDTH * xx - SIN_HALF_LOBE_WIDTH * yy;
            double yyy = SIN_HALF_LOBE_WIDTH * xx + COS_HALF_LOBE_WIDTH * yy;
            switch (lobe) {
                case 1: {
                    x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                    y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                    break;
                }
                case 2: {
                    x = COS_LOBE_WIDTH * xxx + SIN_LOBE_WIDTH * yyy;
                    y = -SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                    break;
                }
                default: {
                    x = xxx;
                    y = yyy;
                }
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = this.outCenterYActual_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lambdaRad;
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = this.outCenterYActual_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        double xOverRS = absx * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + (yOverRS = y * this.invRS_) * yOverRS);
        if (rho > Math.PI) {
            return null;
        }
        double phiRad = 1.5707963267948966 - rho;
        if (phiRad >= JOIN_LAT_RAD) {
            lambdaRad = Math.atan2(absx, -y);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
            double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double alphaRad = rho;
            double betaRad = Math.atan2(Math.abs(xrot), -yrot);
            lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
            if (lambdaRad > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            if (xrot < 0.0) {
                lambdaRad = -lambdaRad;
            }
            lambdaRad -= rotateRad;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        if ((phi = Math.toDegrees(phiRad)) < -90.0) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BartholomewTetrahedral bartholomewTetrahedral = this;
        synchronized (bartholomewTetrahedral) {
            for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y2OverR2S2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverR2S2);
                    if (rho > Math.PI) continue;
                    double phiRad = 1.5707963267948966 - rho;
                    if (phiRad >= JOIN_LAT_RAD) {
                        lambdaRad = Math.atan2(xOverRS, -yOverRS);
                    } else {
                        double zetaRad = Math.atan2(xOverRS, -yOverRS);
                        int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
                        double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double alphaRad = rho;
                        double betaRad = Math.atan2(Math.abs(xrot), -yrot);
                        lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
                        if (lambdaRad > HALF_LOBE_WIDTH_RAD) continue;
                        if (xrot < 0.0) {
                            lambdaRad = -lambdaRad;
                        }
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 3; ++i) {
            double lon1 = this.lambdaC_ + (double)i * 120.0 + 1.0E-5;
            double lon2 = this.lambdaC_ + (double)i * 120.0 + 120.0 - 1.0E-5;
            Bezier bcurve = this.makeMeridianBezier(lon1);
            if (bcurve != null) {
                bcurve.draw(g2d);
            }
            if ((bcurve = this.makeMeridianBezier(lon2)) == null) continue;
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat >= 23.5) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 60.0, lat);
            if (dot == null) {
                return;
            }
            double dx = (double)this.outCenterX_ - dot.x;
            double dy = this.outCenterYActual_ - dot.y;
            double r = Math.sqrt(dx * dx + dy * dy);
            g2d.translate((double)this.outCenterX_, this.outCenterYActual_);
            ProjectionUtils.drawEllipse(g2d, 0.0, 0.0, r, r);
            g2d.translate((double)(-this.outCenterX_), -this.outCenterYActual_);
        } else {
            for (int i = 0; i < 3; ++i) {
                double lon1 = this.lambdaC_ + (double)i * 120.0 + 1.0E-5;
                double lon2 = this.lambdaC_ + (double)i * 120.0 + 60.0;
                double lon3 = this.lambdaC_ + (double)i * 120.0 + 120.0 - 1.0E-5;
                Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
                Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
                Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
                GraphicUtils.drawCircularArc(g2d, dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        for (int i = 0; i < 3; ++i) {
            double lobeCenter = MapUtils.normalizeMP180(this.lambdaC_ + (double)i * 120.0 + 60.0);
            double cdiff = Math.abs(MapUtils.normalizeMP180(lon - lobeCenter));
            if (cdiff > 60.0) continue;
            Point2D.Double dot90S = this.transformLL2XYIgnoreMargins(lon, -90.0);
            if (Math.abs(cdiff) < 1.0E-5) {
                GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterYActual_, dot90S.x, dot90S.y);
                return;
            }
            Point2D.Double dotEq = this.transformLL2XYIgnoreMargins(lon, 23.5);
            GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterYActual_, dotEq.x, dotEq.y);
            if (cdiff > 59.99999) {
                return;
            }
            Bezier bcurve = this.makeMeridianBezier(lon);
            if (bcurve == null) continue;
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        for (double lat = -90.0; lat < 23.5; lat += 0.5) {
            dot = this.transformLL2XYIgnoreMargins(lon, lat);
            ptlist.add(new Point2D.Double(dot.x, dot.y));
        }
        dot = this.transformLL2XY(lon, 23.5);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }
}

