/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaarSineSeries
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baar Sine Series";
    private static final double DEFAULT_PHITS = 0.0;
    private static final double DEFAULT_K = 1.0;
    private static final double DEFAULT_A = 0.6667;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.sin(1.0472499110741575) / 0.6667;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 0.0, 0.0, 60.0, true, false);
    private final ProjDoubleParameter aParam_ = new ProjDoubleParameter("Parameter a", "Param. a", "", 0.6667, 0.01, 1.0, true, true);
    private double termK_ = 1.0;
    private double invK_ = 1.0;
    private double termA_ = 1.0;
    private double invA_ = 1.0;
    private double kA_ = 1.0;
    private double invKA_ = 1.0;
    private double invKRS_ = 1.0;
    private boolean almostCEA_;

    public BaarSineSeries(int width, int height) {
        this(width, height, 0, 0);
    }

    public BaarSineSeries(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.aParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setStandardParallel(this.phi1Param_.getValue());
            this.setParamA(this.aParam_.getValue());
        } else if (p == this.phi1Param_) {
            this.setStandardParallel(this.phi1Param_.getValue());
        } else if (p == this.aParam_) {
            this.setParamA(this.aParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        this.termK_ = Math.abs(lat) < 1.0E-5 ? 1.0 : Math.cos(Math.toRadians(lat));
        this.invK_ = 1.0 / this.termK_;
        this.autoscale();
    }

    private void setParamA(double a) {
        this.termA_ = a;
        this.invA_ = 1.0 / a;
        this.almostCEA_ = this.termA_ > 0.9999999999;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.kA_ = this.termK_ * this.termA_;
        this.invKA_ = 1.0 / this.kA_;
        double widthFactor = this.termK_ * Math.PI;
        double heightFactor = this.invKA_ * Math.sin(this.termA_ * 1.5707963267948966);
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        this.invKRS_ = this.invK_ * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double kLambdaRad;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double x = kLambdaRad = this.termK_ * this.lonToLambdaRad(lon);
        if (Math.abs(phiRad) < 1.0E-5) {
            y = 0.0;
        } else {
            double aPhiRad = this.termA_ * phiRad;
            if (!this.almostCEA_) {
                x *= Math.cos(phiRad) / Math.cos(aPhiRad);
            }
            y = this.invKA_ * Math.sin(aPhiRad);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double lambdaRad = x * this.invKRS_;
        if (Math.abs(y) < 1.0E-5) {
            phiRad = 0.0;
        } else {
            double sinAPhi = y * this.invRS_ * this.kA_;
            double aPhiRad = Math.asin(sinAPhi);
            phiRad = aPhiRad * this.invA_;
            if (!this.almostCEA_) {
                lambdaRad *= Math.cos(aPhiRad) / Math.cos(phiRad);
            }
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BaarSineSeries baarSineSeries = this;
        synchronized (baarSineSeries) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double sinAPhi = y * this.invRS_ * this.kA_;
                double aPhiRad = Math.asin(sinAPhi);
                double phiRad = aPhiRad * this.invA_;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invKRS_;
                if (!this.almostCEA_) {
                    xFactor *= Math.cos(aPhiRad) / Math.cos(phiRad);
                }
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.termA_ > 0.9999999999) {
            ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        } else {
            super.drawBorderLines(g2d);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.termA_ > 0.9999999999) {
            double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
            if (absLambda > 179.99999) {
                return;
            }
            Point2D.Double dot90N = this.transformLL2XYIgnoreMargins(lon, 90.0);
            Point2D.Double dot90S = this.transformLL2XYIgnoreMargins(lon, -90.0);
            GraphicUtils.drawLine(g2d, dot90N, dot90S);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }
}

