/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzimuthalFarSidePerspective
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Azimuthal Far-Side Perspective";
    public static final int PROPERTIES = 0x200040;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 90.0;
    private static final double DEFAULT_D = 1.7071067811865475;
    private final ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance between point of projection and center of body", "Proj. pt. distance", "Radii (D\u22651)", 1.7071067811865475, 1.0, Double.POSITIVE_INFINITY, true, true);
    private double dPerspective_ = 1.7071067811865475;

    public AzimuthalFarSidePerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalFarSidePerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.addClipAngleParameter(90.0, 90.0, true);
        this.setAzimuthalFill(true);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.distParam_) {
            this.setObserverDistance(this.distParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setObserverDistance(double d) {
        this.dPerspective_ = d;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double cosZ = Math.cos(this.edgeAngleRad_);
        double sinZ = Math.sin(this.edgeAngleRad_);
        double rhoEdgeOverR = this.dPerspective_ * sinZ / (this.dPerspective_ + cosZ);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_;
        this.rhoBorder2_ = this.rS_ * this.rS_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < 0.0) {
            return -1.0;
        }
        return this.dPerspective_ / (this.dPerspective_ + cosZ);
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double dOverRho = this.dPerspective_ / rhoOverRS;
        double z = rhoOverRS;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = this.dPerspective_ + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

