/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArdenClose
extends GlobalCylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Arden-Close";
    private static final double DEFAULT_MAXLAT = 80.0;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.710526903364043;
    private double maxLat_ = 80.0;
    private final ProjDoubleParameter maxLatParam_ = new ProjDoubleParameter("Latitude at top of map", "Max. Latitude", "\u00b0", 80.0, 45.0, 89.9875, true, true);

    public ArdenClose(int width, int height) {
        this(width, height, 0, 0);
    }

    public ArdenClose(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.710526903364043);
        this.addParameter(this.maxLatParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.maxLatParam_) {
            this.setMaxLatitude(this.maxLatParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setMaxLatitude(double lat) {
        this.maxLat_ = lat;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double maxRad = Math.toRadians(this.maxLat_);
        double heightFactor = 0.5 * (Math.sin(maxRad) + Math.log(Math.tan(0.7853981633974483 + 0.5 * maxRad)));
        this.setMaxXYOverRS(Math.PI, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > this.maxLat_) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double y1 = Math.sin(phiRad);
        double y2 = Math.log(Math.tan(0.7853981633974483 + 0.5 * phiRad));
        double x = this.lonToLambdaRad(lon);
        double y = 0.5 * (y1 + y2);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (Math.abs(y) < 1.0E-5) {
            return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), 0.0);
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double inner = 0.7853981633974483 + 0.5 * phiRad;
            double tanTerm = Math.tan(inner);
            double secTerm = 1.0 / Math.cos(inner);
            double dtanTerm = secTerm * secTerm;
            double func = 0.5 * (sinPhi + Math.log(tanTerm)) - yOverRS;
            double dfunc = 0.5 * (cosPhi + 0.5 * (1.0 / tanTerm) * dtanTerm);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ArdenClose ardenClose = this;
        synchronized (ardenClose) {
            double phiRad = 1.0E-5;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    double sinPhi = Math.sin(phiRad);
                    double cosPhi = Math.cos(phiRad);
                    double inner = 0.7853981633974483 + 0.5 * phiRad;
                    double tanTerm = Math.tan(inner);
                    double secTerm = 1.0 / Math.cos(inner);
                    double dtanTerm = secTerm * secTerm;
                    double func = 0.5 * (sinPhi + Math.log(tanTerm)) - yOverRS;
                    double dfunc = 0.5 * (cosPhi + 0.5 * (1.0 / tanTerm) * dtanTerm);
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

