/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.util.ResourceListEntry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayResourceListEntry
extends ResourceListEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public OverlayResourceListEntry(ResourceListEntry.LocType loctype, Object link, Object item) {
        super(loctype, link, item);
    }

    @Override
    protected void load(File f) {
        LOGGER.debug("file {}", (Object)f.getName());
        try {
            this.item_ = OverlayFactory.open(f);
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not load overlay resource %s: %s.%n", f, exc.toString());
        }
    }

    @Override
    protected void load(URL url) {
        LOGGER.debug("url {}", (Object)url.getFile());
        try {
            this.item_ = OverlayFactory.open(url);
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not load overlay resource %s: %s.%n", url, exc.toString());
        }
    }
}

