/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OutlineArea;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutlineOverlay
extends MapOverlay {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ArrayList<OutlineArea> areas_ = new ArrayList(200);
    private boolean contentRead_;

    public OutlineOverlay(File f) throws FileNotFoundException, IOException {
        Objects.requireNonNull(f, "File cannot be null.");
        LOGGER.trace("Construct from File {}", (Object)f.getName());
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.address_ = f;
        this.setIdentifier(f.toURI().toURL().toString());
        try (FileInputStream fstream = new FileInputStream(f);){
            this.readHeader(fstream);
        }
    }

    public OutlineOverlay(URL url) throws IOException {
        Objects.requireNonNull(url, "URL cannot be null.");
        LOGGER.trace("Construct from URL {}", (Object)url.getFile());
        this.address_ = url;
        this.setIdentifier(url.toString());
        try (InputStream istream = url.openStream();){
            this.readHeader(istream);
        }
    }

    public OutlineOverlay(byte[] bytes, String id) throws IOException {
        LOGGER.trace("Construct from byte array.");
        this.setIdentifier(id);
        try (ByteArrayInputStream astream = new ByteArrayInputStream(bytes);){
            this.readFullContent(astream);
            this.contentRead_ = true;
        }
    }

    protected abstract boolean readHeader(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFullContent() throws IOException {
        OutlineOverlay outlineOverlay = this;
        synchronized (outlineOverlay) {
            if (this.address_ == null) {
                throw new RuntimeException("Overlay address is null");
            }
            if (this.address_ instanceof File) {
                try (FileInputStream fstream = new FileInputStream((File)this.address_);){
                    this.readFullContent(fstream);
                }
            } else if (this.address_ instanceof URL) {
                try (InputStream istream = ((URL)this.address_).openStream();){
                    this.readFullContent(istream);
                }
            } else {
                throw new RuntimeException("Overlay address must be a File or URL");
            }
            this.contentRead_ = true;
        }
    }

    protected void setContentRead() {
        this.contentRead_ = true;
    }

    protected abstract void readFullContent(InputStream var1) throws IOException;

    public int size() {
        block3: {
            try {
                if (!this.contentRead_) {
                    this.contentRead_ = true;
                    this.readFullContent();
                }
            }
            catch (Exception exc) {
                LOGGER.error("Could not read overlay content.");
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        return this.areas_.size();
    }

    protected void addArea(OutlineArea area) {
        block3: {
            try {
                if (!this.contentRead_) {
                    this.contentRead_ = true;
                    this.readFullContent();
                }
            }
            catch (Exception exc) {
                LOGGER.error("Could not read overlay content.");
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        this.areas_.add(area);
    }

    public OutlineArea getArea(int index) {
        block3: {
            try {
                if (!this.contentRead_) {
                    this.contentRead_ = true;
                    this.readFullContent();
                }
            }
            catch (Exception exc) {
                LOGGER.error("Could not read overlay content.");
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        return this.areas_.get(index);
    }
}

