/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import gov.nasa.giss.map.CoordinateSystem;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.landmarks.LandmarkList;
import gov.nasa.giss.map.landmarks.LandmarkType;
import gov.nasa.giss.math.PointLL;
import java.text.ParseException;
import java.util.Iterator;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Landmark {
    private static final Logger LOGGER = LoggerFactory.getLogger(Landmark.class);
    private double oblate_;
    private PointLL lonlatPG_;
    private PointLL lonlatPC_;
    private LandmarkList parent_;
    private LandmarkType ltype_ = LandmarkType.UNKNOWN;
    private boolean marked_;
    private String code_;
    private String name_;
    private String description_;

    public Landmark(LandmarkList parent, Element node) throws ParseException {
        this(parent, node, 0.0);
    }

    public Landmark(LandmarkList parent, Element node, double oblate) throws ParseException {
        this.parent_ = parent;
        this.oblate_ = oblate;
        Iterator<Element> iter = node.getChildren().iterator();
        Attribute markedA = node.getAttribute("marked");
        if (markedA != null) {
            String s = markedA.getValue().toLowerCase();
            this.setMarked("marked".equals(s) || "true".equals(s) || "1".equals(s) || "yes".equals(s) || "on".equals(s));
        }
        while (iter.hasNext()) {
            Element child = iter.next();
            String childName = child.getName();
            if ("name".equals(childName)) {
                this.name_ = child.getText();
                continue;
            }
            if ("code".equals(childName)) {
                this.code_ = child.getText();
                continue;
            }
            if ("coords".equals(childName)) {
                Attribute lonA = child.getAttribute("lon");
                double lon = 0.0;
                try {
                    lon = lonA == null ? 0.0 : lonA.getDoubleValue();
                }
                catch (Exception exc) {
                    throw new ParseException("Bad longitude attribute in coords : " + lonA.getValue(), 0);
                }
                Attribute latA = child.getAttribute("lat");
                double lat = 0.0;
                try {
                    lat = latA == null ? 0.0 : latA.getDoubleValue();
                }
                catch (Exception exc) {
                    throw new ParseException("Bad latitude attribute in coords : " + latA.getValue(), 0);
                }
                try {
                    Attribute schemeA = child.getAttribute("scheme");
                    if (schemeA == null) {
                        this.lonlatPG_ = new PointLL(lon, lat);
                        continue;
                    }
                    String s = schemeA.getValue().toLowerCase();
                    if ("pc".equals(s) || s.indexOf("centric") > -1) {
                        this.lonlatPC_ = new PointLL(lon, lat);
                        continue;
                    }
                    if ("pg".equals(s) || s.indexOf("graphic") > -1) {
                        this.lonlatPG_ = new PointLL(lon, lat);
                        continue;
                    }
                    throw new ParseException("Bad pg/pc scheme attribute in coords", 0);
                }
                catch (Exception exc) {
                    throw new ParseException("Bad scheme attribute in coords", 0);
                }
            }
            if ("type".equals(childName)) {
                String value = child.getText();
                if (value.indexOf("active") > -1) {
                    this.ltype_ = LandmarkType.ACTIVE_LANDER;
                    continue;
                }
                if (value.indexOf("planned") > -1) {
                    this.ltype_ = LandmarkType.PLANNED_LANDER;
                    continue;
                }
                if (value.indexOf("crash") > -1) {
                    this.ltype_ = LandmarkType.CRASH_SITE;
                    continue;
                }
                if (value.indexOf("lander") > -1) {
                    this.ltype_ = LandmarkType.PAST_LANDER;
                    continue;
                }
                if (value.indexOf("feature") > -1 || value.indexOf("crater") > -1) {
                    this.ltype_ = LandmarkType.FEATURE;
                    continue;
                }
                if (value.indexOf("region") > -1) {
                    this.ltype_ = LandmarkType.REGION;
                    continue;
                }
                this.ltype_ = LandmarkType.UNKNOWN;
                continue;
            }
            if ("notes".equals(childName)) {
                this.description_ = child.getText();
                continue;
            }
            if ("longitude".equals(childName)) {
                if (this.lonlatPG_ == null) {
                    this.lonlatPG_ = new PointLL();
                }
                try {
                    this.lonlatPG_.setLon(Double.parseDouble(child.getText()));
                    continue;
                }
                catch (Exception exc) {
                    throw new ParseException("Bad CDATA in longitude", 0);
                }
            }
            if (!"latitude".equals(childName)) continue;
            if (this.lonlatPG_ == null) {
                this.lonlatPG_ = new PointLL();
            }
            try {
                this.lonlatPG_.setLat(Double.parseDouble(child.getText()));
            }
            catch (Exception exc) {
                throw new ParseException("Bad CDATA in latitude", 0);
            }
        }
        this.convertCoords();
        if (this.code_ == null) {
            this.code_ = "XXX";
        }
        if (this.name_ == null) {
            this.name_ = "Unnamed site";
        }
    }

    public Landmark(LandmarkList parent, LandmarkType ltype, double lon, double lat, String code, String name) {
        this.parent_ = parent;
        this.ltype_ = ltype;
        this.marked_ = false;
        this.code_ = code;
        this.name_ = name;
        this.lonlatPG_ = new PointLL(lon, lat);
        this.convertCoords();
    }

    private void convertCoords() {
        if (this.lonlatPC_ == null && this.lonlatPG_ == null) {
            throw new RuntimeException("Cannot convert coordinates: both p'c and p'g are null");
        }
        if (this.lonlatPC_ != null && this.lonlatPG_ != null) {
            LOGGER.info("No conversion needed. Both p's and p'g coordinates are set.");
        }
        if (this.oblate_ == 0.0) {
            if (this.lonlatPG_ != null) {
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), this.lonlatPG_.getLat());
            } else {
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), this.lonlatPC_.getLat());
            }
        } else if (this.lonlatPG_ != null) {
            double lat = this.lonlatPG_.getLat();
            if (lat == 0.0 || Math.abs(lat) == 90.0) {
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), this.lonlatPG_.getLat());
            } else {
                double latPC = Math.toDegrees(Math.atan(Math.tan(Math.toRadians(lat)) * ((1.0 - this.oblate_) * (1.0 - this.oblate_))));
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), latPC);
            }
        } else {
            double lat = this.lonlatPC_.getLat();
            if (lat == 0.0 || Math.abs(lat) == 90.0) {
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), this.lonlatPC_.getLat());
            } else {
                double latPG = Math.toDegrees(Math.atan(Math.tan(Math.toRadians(lat)) / ((1.0 - this.oblate_) * (1.0 - this.oblate_))));
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), latPG);
            }
        }
    }

    public LandmarkType getType() {
        return this.ltype_;
    }

    public PointLL getPoint() {
        return this.lonlatPG_.copy();
    }

    public double getLon() {
        return MapUtils.normalize360(this.lonlatPG_.getLon());
    }

    public double getLat() {
        return this.lonlatPG_.getLat();
    }

    public PointLL getPoint(CoordinateSystem csystem) {
        return csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.copy() : this.lonlatPC_.copy();
    }

    public double getLon(CoordinateSystem csystem) {
        double lon = csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.getLon() : this.lonlatPC_.getLon();
        return MapUtils.normalize360(lon);
    }

    public double getLat(CoordinateSystem csystem) {
        return csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.getLat() : this.lonlatPC_.getLat();
    }

    public String getName() {
        return this.name_;
    }

    public String getCode() {
        return this.code_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean isMarked() {
        return this.marked_;
    }

    public void setMarked(boolean marked) {
        if (marked == this.marked_) {
            return;
        }
        this.marked_ = marked;
        if (this.parent_ != null) {
            this.parent_.landmarkChanged(this);
        }
    }

    public int compareTo(Landmark o) {
        return this.compareByType(o);
    }

    public int compareByMark(Landmark o) {
        boolean i2;
        boolean i1 = this.isMarked();
        if (i1 == (i2 = o.isMarked())) {
            return this.compareByName(o);
        }
        if (i1 && !i2) {
            return -1;
        }
        return 1;
    }

    public int compareByType(Landmark o) {
        int i2;
        int i1 = this.ltype_.getSortOrder();
        if (i1 > (i2 = o.getType().getSortOrder())) {
            return 1;
        }
        if (i1 < i2) {
            return -1;
        }
        return this.compareByName(o);
    }

    public int compareByCode(Landmark o) {
        return this.code_.compareTo(o.getCode());
    }

    public int compareByName(Landmark o) {
        return this.name_.compareTo(o.getName());
    }

    public int compareByLongitude(Landmark o) {
        double lon1 = this.getLon();
        double lon2 = o.getLon();
        if (lon1 < 0.0) {
            lon1 += 360.0;
        }
        if (lon2 < 0.0) {
            lon2 += 360.0;
        }
        if (lon1 > lon2) {
            return 10;
        }
        if (lon1 < lon2) {
            return -10;
        }
        return 0;
    }

    public int compareByLatitude(Landmark o) {
        double lat2;
        double lat1 = this.getLat();
        if (lat1 > (lat2 = o.getLat())) {
            return 10;
        }
        if (lat1 < lat2) {
            return -10;
        }
        return 0;
    }
}

