/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.kml;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.util.ResourceListEntry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLDataResourceListEntry
extends ResourceListEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public KMLDataResourceListEntry(ResourceListEntry.LocType loctype, Object link, Object item) {
        super(loctype, link, item);
    }

    @Override
    protected void load(File f) {
        try {
            this.item_ = new KMLData(f);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load KML data resource from File {}", (Object)f);
            LOGGER.warn("Exception was {}", (Object)exc.toString());
        }
    }

    @Override
    protected void load(URL url) {
        try {
            this.item_ = new KMLData(url);
            ((KMLData)this.item_).parse();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load KML data resource from URL {}", (Object)url);
            LOGGER.warn("Exception was {}", (Object)exc.toString());
        }
    }

    public void flush() {
        if (this.item_ instanceof KMLData) {
            ((KMLData)this.item_).flush();
        }
    }
}

