/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

public class LonLatRotator {
    private double lambdaCRad_;
    private double phiCRad_;
    private double alpha_;
    private double alphaRad_;
    private double[][] rotZ_ = new double[3][3];
    private double[][] rotY_ = new double[3][3];
    private double[][] rotX_ = new double[3][3];

    public LonLatRotator() {
        this(0.0, 0.0, 0.0);
    }

    public LonLatRotator(double lambdaC, double phiC) {
        this(lambdaC, phiC, 0.0);
    }

    public LonLatRotator(double lambdaC, double phiC, double alpha) {
        this.setAngles(lambdaC, phiC, alpha);
    }

    public void setAngles(double lambdaC, double phiC) {
        this.setAngles(lambdaC, phiC, 0.0);
    }

    public final void setAngles(double lambdaC, double phiC, double alpha) {
        this.alpha_ = alpha;
        this.lambdaCRad_ = Math.toRadians(lambdaC);
        this.phiCRad_ = Math.toRadians(phiC);
        this.alphaRad_ = Math.toRadians(alpha);
        this.initMatrices();
    }

    private void initMatrices() {
        double alphaRad = this.alphaRad_;
        double betaRad = this.phiCRad_;
        double gammaRad = -this.lambdaCRad_;
        double cosAlpha = Math.cos(alphaRad);
        double sinAlpha = Math.sin(alphaRad);
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotX_[0][0] = 1.0;
        this.rotX_[0][1] = 0.0;
        this.rotX_[0][2] = 0.0;
        this.rotX_[1][0] = 0.0;
        this.rotX_[1][1] = cosAlpha;
        this.rotX_[1][2] = -sinAlpha;
        this.rotX_[2][0] = 0.0;
        this.rotX_[2][1] = sinAlpha;
        this.rotX_[2][2] = cosAlpha;
        this.rotY_[0][0] = cosBeta;
        this.rotY_[0][1] = 0.0;
        this.rotY_[0][2] = sinBeta;
        this.rotY_[1][0] = 0.0;
        this.rotY_[1][1] = 1.0;
        this.rotY_[1][2] = 0.0;
        this.rotY_[2][0] = -sinBeta;
        this.rotY_[2][1] = 0.0;
        this.rotY_[2][2] = cosBeta;
        this.rotZ_[0][0] = cosGamma;
        this.rotZ_[0][1] = -sinGamma;
        this.rotZ_[0][2] = 0.0;
        this.rotZ_[1][0] = sinGamma;
        this.rotZ_[1][1] = cosGamma;
        this.rotZ_[1][2] = 0.0;
        this.rotZ_[2][0] = 0.0;
        this.rotZ_[2][1] = 0.0;
        this.rotZ_[2][2] = 1.0;
    }

    public double[] rotate(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = Math.toRadians(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double[] p0 = new double[]{cosPhi * Math.cos(lambdaRad), cosPhi * Math.sin(lambdaRad), sinPhi};
        double[] p1 = new double[]{this.rotZ_[0][0] * p0[0] + this.rotZ_[0][1] * p0[1], this.rotZ_[1][0] * p0[0] + this.rotZ_[1][1] * p0[1], p0[2]};
        double[] p2 = new double[]{this.rotY_[0][0] * p1[0] + this.rotY_[0][2] * p1[2], p1[1], this.rotY_[2][0] * p1[0] + this.rotY_[2][2] * p1[2]};
        if (this.alpha_ == 0.0) {
            double lon2 = Math.toDegrees(Math.atan2(p2[1], p2[0]));
            double lat2 = Math.toDegrees(Math.asin(p2[2]));
            return new double[]{lon2, lat2};
        }
        double[] p3 = new double[]{p2[0], this.rotX_[1][1] * p2[1] + this.rotX_[1][2] * p2[2], this.rotX_[2][1] * p2[1] + this.rotX_[2][2] * p2[2]};
        double lonP = Math.toDegrees(Math.atan2(p3[1], p3[0]));
        double latP = Math.toDegrees(Math.asin(p3[2]));
        return new double[]{lonP, latP};
    }

    public double[] inverse(double lonP, double latP) {
        if (Math.abs(latP) > 90.0) {
            throw new IllegalArgumentException("Lat(p) must be in range [-90\u0080,90\u0080].");
        }
        double lambdaPRad = Math.toRadians(lonP);
        double phiPRad = Math.toRadians(latP);
        double cosPhiP = Math.cos(phiPRad);
        double sinPhiP = Math.sin(phiPRad);
        double[] p0 = new double[]{cosPhiP * Math.cos(lambdaPRad), cosPhiP * Math.sin(lambdaPRad), sinPhiP};
        double[] p1 = this.alpha_ == 0.0 ? p0 : new double[]{p0[0], this.rotX_[1][1] * p0[1] + this.rotX_[2][1] * p0[2], this.rotX_[1][2] * p0[1] + this.rotX_[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotY_[0][0] * p1[0] + this.rotY_[2][0] * p1[2], p1[1], this.rotY_[0][2] * p1[0] + this.rotY_[2][2] * p1[2]};
        double[] p3 = new double[]{this.rotZ_[0][0] * p2[0] + this.rotZ_[1][0] * p2[1], this.rotZ_[0][1] * p2[0] + this.rotZ_[1][1] * p2[1], p2[2]};
        double lon = Math.toDegrees(Math.atan2(p3[1], p3[0]));
        double lat = Math.toDegrees(Math.asin(p3[2]));
        return new double[]{lon, lat};
    }
}

