/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.img.GifWriter;
import gov.nasa.giss.img.TiffUtils;
import gov.nasa.giss.img.TiffWriter;
import gov.nasa.giss.io.FileUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String JPG_EXT = "jpg";
    private static final String JPEG_EXT = "jpeg";
    private static final String TIF_EXT = "tif";
    private static final String TIFF_EXT = "tiff";
    private static final Object SAVE_LOCK = new Object();
    private static String[] readableImageExtensions_;
    private static GifWriter gifWriter_;
    private static TiffWriter tiffWriter_;

    public static String[] getReadableImageFileExtensions() {
        if (readableImageExtensions_ != null) {
            return readableImageExtensions_;
        }
        String[] readerExts = ImageIO.getReaderFormatNames();
        ArrayList<String> formatExts = new ArrayList<String>(30);
        for (String ext : readerExts) {
            String lcExt = ext.toLowerCase();
            boolean already = false;
            for (String ext2 : formatExts) {
                if (!ext2.equals(lcExt)) continue;
                already = true;
                break;
            }
            if (already) continue;
            formatExts.add(lcExt);
        }
        boolean jpgPresent = false;
        boolean jpegPresent = false;
        boolean tifPresent = false;
        boolean tiffPresent = false;
        for (String ext : formatExts) {
            if (ext.equalsIgnoreCase(JPG_EXT)) {
                jpgPresent = true;
            } else if (ext.equalsIgnoreCase(JPEG_EXT)) {
                jpegPresent = true;
            }
            if (ext.equalsIgnoreCase(TIF_EXT)) {
                tifPresent = true;
                continue;
            }
            if (!ext.equalsIgnoreCase(TIFF_EXT)) continue;
            tiffPresent = true;
        }
        if (jpgPresent && !jpegPresent) {
            formatExts.add(JPEG_EXT);
        }
        if (jpegPresent && !jpgPresent) {
            formatExts.add(JPG_EXT);
        }
        if (tifPresent && !tiffPresent) {
            formatExts.add(TIFF_EXT);
        }
        if (tiffPresent && !tifPresent) {
            formatExts.add(TIF_EXT);
        }
        Collections.sort(formatExts);
        readableImageExtensions_ = formatExts.toArray(new String[0]);
        return readableImageExtensions_;
    }

    public static Dimension getImageDimensions(File f) throws FileNotFoundException, IOException, UnsupportedOperationException {
        Dimension dd;
        Objects.requireNonNull(f, "File object cannot be null");
        String lcext = FileUtils.extractFnameExt(f).toLowerCase();
        try (FileImageInputStream fiis = new FileImageInputStream(f);){
            Dimension dd2 = ImageUtils.getImageDimensions(fiis, lcext);
            if (dd2 != null) {
                Dimension dimension = dd2;
                return dimension;
            }
        }
        if ((lcext.equals(TIF_EXT) || lcext.equals(TIFF_EXT)) && (dd = TiffUtils.getImageDimensions(f)) != null) {
            return dd;
        }
        throw new UnsupportedOperationException("No header reader available for that image type.");
    }

    private static Dimension getImageDimensions(FileImageInputStream fiis, String fext) throws IOException {
        Objects.requireNonNull(fext, "Extension cannot be null");
        String lcext = fext.toLowerCase();
        Iterator<ImageReader> readers = ImageIO.getImageReaders(fiis);
        if (!readers.hasNext()) {
            LOGGER.debug("No readers found");
            readers = ImageIO.getImageReadersBySuffix(lcext);
        }
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(fiis);
            Dimension d = new Dimension(reader.getWidth(0), reader.getHeight(0));
            reader.dispose();
            return d;
        }
        return null;
    }

    public static BufferedImage toBufferedImage(File f) throws FileNotFoundException, IOException {
        String lcname = f.getName().toLowerCase();
        BufferedImage bimg = null;
        if (lcname.endsWith(".jpg") || lcname.endsWith(".jpeg")) {
            ImageIcon ii = new ImageIcon(f.toURI().toURL());
            bimg = ImageUtils.toBufferedImage(ii.getImage());
        } else {
            bimg = ImageIO.read(f);
        }
        if (bimg == null) {
            throw new IllegalArgumentException("There is apparently no ImageIO reader registered for that file.");
        }
        return bimg;
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage bimage = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)bimage.getGraphics();
        if (icon instanceof ImageIcon) {
            g2d.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        } else {
            icon.paintIcon(null, g2d, 0, 0);
        }
        g2d.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        Image iimage = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(iimage);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasAlpha ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(iimage.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = hasAlpha ? 2 : 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    public static int[] getARGBPixels(BufferedImage img) {
        Objects.requireNonNull(img, "Image cannot be null");
        int biType = img.getType();
        WritableRaster raster = img.getRaster();
        LOGGER.debug("bitype {}", (Object)biType);
        LOGGER.debug("dttype {}", (Object)raster.getTransferType());
        LOGGER.debug("model class {}", (Object)img.getColorModel().getClass());
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pixels = new int[w * h];
        switch (biType) {
            case 1: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 2: {
                raster.getDataElements(0, 0, w, h, pixels);
                break;
            }
            case 3: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 5: {
                byte[] scratch = new byte[3 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 3 + 2] & 0xFF) + ((scratch[i * 3 + 1] & 0xFF) << 8) + ((scratch[i * 3 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 6: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = ((scratch[i * 4 + 3] & 0xFF) << 24) + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 7: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 12: 
            case 13: {
                IndexColorModel icm = (IndexColorModel)img.getColorModel();
                int transIdx = icm.getTransparentPixel();
                byte[] rowPixels = new byte[w];
                for (int row = 0; row < h; ++row) {
                    raster.getDataElements(0, row, w, 1, rowPixels);
                    for (int col = 0; col < w; ++col) {
                        int idx = rowPixels[col] & 0xFF;
                        pixels[row * w + col] = idx == transIdx ? 0 : 0xFF000000 | icm.getRGB(idx);
                    }
                }
                break;
            }
            default: {
                LOGGER.trace("Using pixel grabber to decode pixels.");
                try {
                    PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
                    grabber.grabPixels();
                    break;
                }
                catch (InterruptedException exc) {
                    LOGGER.debug("Couldn't get pixels from PixelGrabber.");
                    LOGGER.debug("Returning unfilled array!");
                    if (!LOGGER.isTraceEnabled()) break;
                    exc.printStackTrace();
                }
            }
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsGif(File f, BufferedImage img) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            if (gifWriter_ == null) {
                gifWriter_ = new GifWriter();
            } else {
                gifWriter_.flush();
            }
            gifWriter_.setImage(img);
            gifWriter_.write(f);
        }
        return true;
    }

    public static boolean saveAsGif(File f, GPrintable plot) throws IOException {
        BufferedImage img = plot.getImage();
        return ImageUtils.saveAsGif(f, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsJpeg(File f, BufferedImage img, float quality) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(JPEG_EXT);
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(f);){
                writer.setOutput(ios);
                writer.write(null, new IIOImage(img, null, null), iwp);
                ios.flush();
                writer.dispose();
            }
        }
        return true;
    }

    public static boolean saveAsJpeg(File f, GPrintable plot) throws IOException {
        BufferedImage img = plot.getImage();
        return ImageUtils.saveAsJpeg(f, img, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsPng(File f, BufferedImage img) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            ImageIO.write((RenderedImage)img, "png", f);
        }
        return true;
    }

    public static boolean saveAsPng(File f, GPrintable plot) throws IOException {
        BufferedImage img = plot.getImage();
        return ImageUtils.saveAsPng(f, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsTiff(File f, BufferedImage img, String software) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            if (tiffWriter_ == null) {
                tiffWriter_ = new TiffWriter();
            } else {
                tiffWriter_.flush();
            }
            tiffWriter_.setImage(img);
            if (software != null) {
                tiffWriter_.setSoftware(software);
            }
            tiffWriter_.write(f);
        }
        return true;
    }

    public static boolean saveAsTiff(File f, GPrintable plot, String software) throws IOException {
        BufferedImage img = plot.getImage();
        return ImageUtils.saveAsTiff(f, img, software);
    }

    private ImageUtils() {
    }
}

