/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatProjected;
import gov.nasa.giss.math.MathUtils;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatRotatedPole
extends NcGridderLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void constrainIntermediateGridBoundsXXXX(NcArrayLonLatProjected nca) {
        double outWW = this.rBound_ - this.lBound_;
        if (outWW > 45.0) {
            return;
        }
        LOGGER.trace("outWW {}", (Object)outWW);
        Point2D.Double tlPt = nca.transformLL2XY(this.lBound_, this.tBound_);
        Point2D.Double mlPt = nca.transformLL2XY(this.lBound_, 0.5 * (this.tBound_ + this.bBound_));
        Point2D.Double blPt = nca.transformLL2XY(this.lBound_, this.bBound_);
        Point2D.Double trPt = nca.transformLL2XY(this.rBound_, this.tBound_);
        Point2D.Double mrPt = nca.transformLL2XY(this.rBound_, 0.5 * (this.tBound_ + this.bBound_));
        Point2D.Double brPt = nca.transformLL2XY(this.rBound_, this.bBound_);
        double leftRotLon = MathUtils.min(tlPt.x, mlPt.x, blPt.x);
        double rightRotLon = MathUtils.max(trPt.x, mrPt.x, brPt.x);
        if (leftRotLon > rightRotLon) {
            leftRotLon -= 360.0;
        }
        if (leftRotLon > this.lProjBound_) {
            this.lProjBound_ = leftRotLon;
        }
        if (rightRotLon < this.rProjBound_) {
            this.rProjBound_ = rightRotLon;
        }
        Point2D.Double tmPt = nca.transformLL2XY(0.5 * (this.lBound_ + this.rBound_), this.tBound_);
        double[] dArray = new double[]{tlPt.y, tmPt.y, trPt.y};
        double topRotLat = MathUtils.max(dArray);
        if (topRotLat < this.tProjBound_ && this.tProjBound_ > this.bProjBound_) {
            this.tProjBound_ = topRotLat;
        } else if (topRotLat < this.bProjBound_ && this.bProjBound_ > this.tProjBound_) {
            this.bProjBound_ = topRotLat;
        }
        Point2D.Double bmPt = nca.transformLL2XY(0.5 * (this.lBound_ + this.rBound_), this.bBound_);
        double bottomRotLat = MathUtils.min(blPt.y, bmPt.y, brPt.y);
        if (bottomRotLat > this.bProjBound_ && this.bProjBound_ < this.tProjBound_) {
            this.bProjBound_ = bottomRotLat;
        } else if (bottomRotLat > this.tProjBound_ && this.tProjBound_ < this.bProjBound_) {
            this.tProjBound_ = bottomRotLat;
        }
    }

    @Override
    protected void transformProjectedGrid(NcArrayLonLatProjected anca, double[] fromArray, double[] toArray) {
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rowLat = this.tBound_ + ((double)row + 0.5) * this.yDegPerPxl_;
            for (int col = 0; col < this.gridWidth_; ++col) {
                double altRow;
                double colLon = this.lBound_ + ((double)col + 0.5) * this.xDegPerPxl_;
                Point2D.Double fromXY = anca.transformLL2XY(colLon, rowLat);
                if (fromXY == null) continue;
                double dlonProj = fromXY.x - this.lProjBound_;
                if (dlonProj < 0.0) {
                    dlonProj += 360.0;
                } else if (dlonProj > 360.0) {
                    dlonProj -= 360.0;
                }
                double altCol = dlonProj * this.xPxlPerProj_ + 0.5;
                if (altCol < 0.0 || altCol >= (double)this.iigridWidth_ || (altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5) < 0.0 || altRow >= (double)this.iigridHeight_) continue;
                int fromIndex = (int)altRow * this.iigridWidth_ + (int)altCol;
                int toIndex = row * this.gridWidth_ + col;
                toArray[toIndex] = fromArray[fromIndex];
            }
        }
    }
}

