/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatCubedSphereCAMSE
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcGridderLonLatCubedSphereCAMSE() {
        this(100, 50);
    }

    public NcGridderLonLatCubedSphereCAMSE(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatCubedSphereCAMSE(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatCubedSphereCAMSE nca = (NcArrayLonLatCubedSphereCAMSE)a;
        int numCorners = nca.getNumCorners();
        boolean hasBad = nca.hasBadValues();
        Line2D.Double testA = new Line2D.Double();
        Line2D.Double testB = new Line2D.Double();
        for (int i = 0; i < numCorners; ++i) {
            double swap;
            double value = nca.valueAt(i);
            if (hasBad && nca.isMissingOrInvalid(value)) continue;
            int[] elemIDs = nca.getCornerElems(i);
            boolean doubleCorner = elemIDs[3] < 0;
            PointLL p1 = nca.getElementLonLatAt(elemIDs[0]);
            PointLL p2 = nca.getElementLonLatAt(elemIDs[1]);
            PointLL p3 = nca.getElementLonLatAt(elemIDs[2]);
            double lon1 = p1.getLon();
            double lon2 = p2.getLon();
            double lon3 = p3.getLon();
            double lat1 = p1.getLat();
            double lat2 = p2.getLat();
            double lat3 = p3.getLat();
            if (lon1 - lon2 > 180.0) {
                lon2 += 360.0;
            } else if (lon2 - lon1 > 180.0) {
                lon2 -= 360.0;
            }
            if (lon1 - lon3 > 180.0) {
                lon3 += 360.0;
            } else if (lon3 - lon1 > 180.0) {
                lon3 -= 360.0;
            }
            if (doubleCorner) {
                this.triSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, value, target);
                continue;
            }
            PointLL p4 = nca.getElementLonLatAt(elemIDs[3]);
            double lon4 = p4.getLon();
            double lat4 = p4.getLat();
            if (lon1 - lon4 > 180.0) {
                lon4 += 360.0;
            } else if (lon4 - lon1 > 180.0) {
                lon4 -= 360.0;
            }
            testA.setLine(lon1, lat1, lon2, lat2);
            testB.setLine(lon3, lat3, lon4, lat4);
            if (testA.intersectsLine(testB)) {
                swap = lon2;
                lon2 = lon3;
                lon3 = swap;
                swap = lat2;
                lat2 = lat3;
                lat3 = swap;
            }
            testA.setLine(lon1, lat1, lon4, lat4);
            testB.setLine(lon2, lat2, lon3, lat3);
            if (testA.intersectsLine(testB)) {
                swap = lon3;
                lon3 = lon4;
                lon4 = swap;
                swap = lat3;
                lat3 = lat4;
                lat4 = swap;
            }
            this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatCubedSphereCAMSE nca = (NcArrayLonLatCubedSphereCAMSE)a;
        boolean hasBad = nca.hasBadValues();
        int numElements = nca.getNumElements();
        for (int i = 0; i < numElements; ++i) {
            int[] cornerIDs = nca.getElementCorners(i);
            double lat1 = nca.getCornerLatitudeAt(cornerIDs[0]);
            double lat2 = nca.getCornerLatitudeAt(cornerIDs[1]);
            double lat3 = nca.getCornerLatitudeAt(cornerIDs[2]);
            double lat4 = nca.getCornerLatitudeAt(cornerIDs[3]);
            double lon1 = nca.getCornerLongitudeAt(cornerIDs[0]);
            double lon2 = nca.getCornerLongitudeAt(cornerIDs[1]);
            double lon3 = nca.getCornerLongitudeAt(cornerIDs[2]);
            double lon4 = nca.getCornerLongitudeAt(cornerIDs[3]);
            if (lon1 - lon2 > 180.0) {
                lon2 += 360.0;
            } else if (lon2 - lon1 > 180.0) {
                lon2 -= 360.0;
            }
            if (lon1 - lon3 > 180.0) {
                lon3 += 360.0;
            } else if (lon3 - lon1 > 180.0) {
                lon3 -= 360.0;
            }
            if (lon1 - lon4 > 180.0) {
                lon4 += 360.0;
            } else if (lon4 - lon1 > 180.0) {
                lon4 -= 360.0;
            }
            double value1 = Double.NaN;
            double value2 = Double.NaN;
            double value3 = Double.NaN;
            double value4 = Double.NaN;
            try {
                value1 = nca.valueAt(cornerIDs[0]);
                value2 = nca.valueAt(cornerIDs[1]);
                value3 = nca.valueAt(cornerIDs[2]);
                value4 = nca.valueAt(cornerIDs[3]);
            }
            catch (Exception exc) {
                LOGGER.debug("{}; {}", (Object)i, (Object)exc);
            }
            if (hasBad) {
                if (nca.isMissingOrInvalid(value1)) {
                    value1 = Double.NaN;
                }
                if (nca.isMissingOrInvalid(value2)) {
                    value2 = Double.NaN;
                }
                if (nca.isMissingOrInvalid(value3)) {
                    value3 = Double.NaN;
                }
                if (nca.isMissingOrInvalid(value4)) {
                    value4 = Double.NaN;
                }
            }
            if (Double.isNaN(value2) && Double.isNaN(value3) || Double.isNaN(value3) && Double.isNaN(value4)) continue;
            this.quadInterpolateFillLL(lon1, lat1, value1, lon2, lat2, value2, lon3, lat3, value3, lon4, lat4, value4, target);
        }
    }
}

