/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.gridder.NcGridder2D;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NcGridderLonLat
extends NcGridder2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected double xDegPerPxl_;
    protected double yDegPerPxl_;
    protected double xPxlPerDeg_;
    protected double yPxlPerDeg_;

    public NcGridderLonLat() {
        this(100, 50);
    }

    public NcGridderLonLat(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLat(int w, int h) {
        this.setSize(w, h);
        this.setBounds(-180.0, 90.0, 180.0, -90.0);
    }

    @Override
    public boolean setBounds(double l, double t, double r, double b) {
        double rr;
        double ll = l;
        double d = rr = r > l ? r : r + 360.0;
        if (ll < -360.0) {
            ll += 360.0;
            rr += 360.0;
        } else if (ll > 360.0) {
            ll -= 360.0;
            rr -= 360.0;
        }
        super.setBounds(ll, t, rr, b);
        return true;
    }

    protected void prepareGridAxes() {
        this.xDegPerPxl_ = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
        this.yDegPerPxl_ = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        this.xPxlPerDeg_ = 1.0 / this.xDegPerPxl_;
        this.yPxlPerDeg_ = 1.0 / this.yDegPerPxl_;
        this.colXX_ = new double[this.gridWidth_];
        this.rowYY_ = new double[this.gridHeight_];
        for (int i = 0; i < this.gridWidth_; ++i) {
            this.colXX_[i] = this.lBound_ + ((double)i + 0.5) * this.xDegPerPxl_;
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            this.rowYY_[j] = this.tBound_ + ((double)j + 0.5) * this.yDegPerPxl_;
        }
    }

    protected void quadSolidFillLL(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4, double val, double[] target) {
        this.quadSolidFillLLInternal(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, val, target);
        this.quadSolidFillLLInternal(lon1 - 360.0, lat1, lon2 - 360.0, lat2, lon3 - 360.0, lat3, lon4 - 360.0, lat4, val, target);
        this.quadSolidFillLLInternal(lon1 + 360.0, lat1, lon2 + 360.0, lat2, lon3 + 360.0, lat3, lon4 + 360.0, lat4, val, target);
    }

    private void quadSolidFillLLInternal(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4, double val, double[] target) {
        double x1 = (lon1 - this.lBound_) * this.xPxlPerDeg_;
        double y1 = (lat1 - this.tBound_) * this.yPxlPerDeg_;
        double x2 = (lon2 - this.lBound_) * this.xPxlPerDeg_;
        double y2 = (lat2 - this.tBound_) * this.yPxlPerDeg_;
        double x3 = (lon3 - this.lBound_) * this.xPxlPerDeg_;
        double y3 = (lat3 - this.tBound_) * this.yPxlPerDeg_;
        double x4 = (lon4 - this.lBound_) * this.xPxlPerDeg_;
        double y4 = (lat4 - this.tBound_) * this.yPxlPerDeg_;
        NcGridderUtils.quadSolidFill(x1, y1, x2, y2, x3, y3, x4, y4, val, target, this.gridWidth_, this.gridHeight_);
    }

    protected void quadInterpolateFillLL(double lon1, double lat1, double val1, double lon2, double lat2, double val2, double lon3, double lat3, double val3, double lon4, double lat4, double val4, double[] target) {
        this.quadInterpolateFillLLInternal(lon1, lat1, val1, lon2, lat2, val2, lon3, lat3, val3, lon4, lat4, val4, target);
        if (lon1 > this.rBound_ || lon2 > this.rBound_ || lon3 > this.rBound_ || lon4 > this.rBound_) {
            this.quadInterpolateFillLLInternal(lon1 - 360.0, lat1, val1, lon2 - 360.0, lat2, val2, lon3 - 360.0, lat3, val3, lon4 - 360.0, lat4, val4, target);
        } else if (lon1 < this.lBound_ || lon2 < this.lBound_ || lon3 < this.lBound_ || lon4 < this.lBound_) {
            this.quadInterpolateFillLLInternal(lon1 + 360.0, lat1, val1, lon2 + 360.0, lat2, val2, lon3 + 360.0, lat3, val3, lon4 + 360.0, lat4, val4, target);
        }
    }

    private void quadInterpolateFillLLInternal(double lon1, double lat1, double val1, double lon2, double lat2, double val2, double lon3, double lat3, double val3, double lon4, double lat4, double val4, double[] target) {
        double x1 = (lon1 - this.lBound_) * this.xPxlPerDeg_;
        double x2 = (lon2 - this.lBound_) * this.xPxlPerDeg_;
        double x3 = (lon3 - this.lBound_) * this.xPxlPerDeg_;
        double x4 = (lon4 - this.lBound_) * this.xPxlPerDeg_;
        if (x1 < 0.0 && x2 < 0.0 && x3 < 0.0 && x4 < 0.0) {
            return;
        }
        if (x1 > (double)this.gridWidth_ && x2 > (double)this.gridWidth_ && x3 > (double)this.gridWidth_ && x4 > (double)this.gridWidth_) {
            return;
        }
        double y1 = (lat1 - this.tBound_) * this.yPxlPerDeg_;
        double y2 = (lat2 - this.tBound_) * this.yPxlPerDeg_;
        double y3 = (lat3 - this.tBound_) * this.yPxlPerDeg_;
        double y4 = (lat4 - this.tBound_) * this.yPxlPerDeg_;
        if (y1 < 0.0 && y2 < 0.0 && y3 < 0.0 && y4 < 0.0) {
            return;
        }
        if (y1 > (double)this.gridHeight_ && y2 > (double)this.gridHeight_ && y3 > (double)this.gridHeight_ && y4 > (double)this.gridHeight_) {
            return;
        }
        NcGridderUtils.quadInterpolateFill(x1, y1, val1, x2, y2, val2, x3, y3, val3, x4, y4, val4, target, this.gridWidth_, this.gridHeight_);
    }

    protected void triSolidFillLL(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double val, double[] target) {
        double x1 = (lon1 - this.lBound_) * this.xPxlPerDeg_;
        double x2 = (lon2 - this.lBound_) * this.xPxlPerDeg_;
        double x3 = (lon3 - this.lBound_) * this.xPxlPerDeg_;
        if (x1 < 0.0 && x2 < 0.0 && x3 < 0.0) {
            return;
        }
        if (x1 > (double)this.gridWidth_ && x2 > (double)this.gridWidth_ && x3 > (double)this.gridWidth_) {
            return;
        }
        double y1 = (lat1 - this.tBound_) * this.yPxlPerDeg_;
        double y2 = (lat2 - this.tBound_) * this.yPxlPerDeg_;
        double y3 = (lat3 - this.tBound_) * this.yPxlPerDeg_;
        if (y1 < 0.0 && y2 < 0.0 && y3 < 0.0) {
            return;
        }
        if (y1 > (double)this.gridHeight_ && y2 > (double)this.gridHeight_ && y3 > (double)this.gridHeight_) {
            return;
        }
        NcGridderUtils.triSolidFill(x1, y1, x2, y2, x3, y3, val, target, this.gridWidth_, this.gridHeight_);
    }

    protected void triInterpolateFillLL(double lon1, double lat1, double val1, double lon2, double lat2, double val2, double lon3, double lat3, double val3, double[] target) {
        double x1 = (lon1 - this.lBound_) * this.xPxlPerDeg_;
        double x2 = (lon2 - this.lBound_) * this.xPxlPerDeg_;
        double x3 = (lon3 - this.lBound_) * this.xPxlPerDeg_;
        if (x1 < 0.0 && x2 < 0.0 && x3 < 0.0) {
            return;
        }
        if (x1 > (double)this.gridWidth_ && x2 > (double)this.gridWidth_ && x3 > (double)this.gridWidth_) {
            return;
        }
        double y1 = (lat1 - this.tBound_) * this.yPxlPerDeg_;
        double y2 = (lat2 - this.tBound_) * this.yPxlPerDeg_;
        double y3 = (lat3 - this.tBound_) * this.yPxlPerDeg_;
        if (y1 < 0.0 && y2 < 0.0 && y3 < 0.0) {
            return;
        }
        if (y1 > (double)this.gridHeight_ && y2 > (double)this.gridHeight_ && y3 > (double)this.gridHeight_) {
            return;
        }
        NcGridderUtils.triInterpolateFill(x1, y1, val1, x2, y2, val2, x3, y3, val3, target, this.gridWidth_, this.gridHeight_);
    }
}

